# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CheckNameAvailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible reasons for a name not being available."""

    INVALID = "Invalid"
    """Name is invalid."""
    ALREADY_EXISTS = "AlreadyExists"
    """Name already exists."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class EnablementStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The enablement status of a feature."""

    ENABLED = "Enabled"
    """The feature is Enabled."""
    DISABLED = "Disabled"
    """The feature is Disabled."""


class FreeTrialState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The free-trial state."""

    ACTIVE = "Active"
    """The free-trial is Active."""
    EXPIRED = "Expired"
    """The free-trial is Expired."""
    NOT_ELIGIBLE = "NotEligible"
    """The free-trial is Not Eligible."""
    NOT_REGISTERED = "NotRegistered"
    """The free-trial is Not Registered."""


class OfferingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Offering type state."""

    NOT_APPLICABLE = "NotApplicable"
    """The offeringType is NotApplicable."""
    PRIVATE_PREVIEW = "PrivatePreview"
    """The offeringType is PrivatePreview."""
    PUBLIC_PREVIEW = "PublicPreview"
    """The offeringType is PublicPreview."""
    GENERAL_AVAILABILITY = "GeneralAvailability"
    """The offeringType is GeneralAvailability."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the current operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    CREATING = "Creating"
    """Creation in progress.."""
    DELETING = "Deleting"
    """Deletion in progress.."""
    ACCEPTED = "Accepted"
    """Change accepted for processing.."""


class QuotaNames(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The enum for quota name."""

    SCALABLE_EXECUTION = "ScalableExecution"
    """The quota details for scalable execution feature. When enabled, Playwright client workers can
    connect to cloud-hosted browsers. This can increase the number of parallel workers for a test
    run, significantly minimizing test completion durations."""
    REPORTING = "Reporting"
    """The quota details for reporting feature. When enabled, Playwright client will be able to upload
    and display test results, including artifacts like traces and screenshots, in the Playwright
    portal. This enables faster and more efficient troubleshooting."""
