CREATE TABLE test_points (
    p spoint
);

COPY test_points (p) FROM stdin;
(0.349065850398866 , 0.174532925199433)
(1.59875999207035 , 0.771416330759722)
(1.59876348272885 , 0.77141458543047)
(1.59876697338736 , 0.771412840101218)
(1.59877046404586 , 0.771411094771966)
(1.59877395470437 , 0.771409349442714)
(1.59877744536287 , 0.771407604113461)
(1.59878093602137 , 0.77140585878421)
(1.59878442667988 , 0.771404113454958)
(1.59878791733838 , 0.771402368125706)
(1.59879140799689 , 0.771400622796454)
(1.59879489865539 , 0.771398877467202)
(1.59879838931389 , 0.77139713213795)
(1.5988018799724 , 0.771395386808698)
(1.5988053706309 , 0.771393641479446)
(1.59880886128941 , 0.771391896150194)
(1.59881235194791 , 0.771390150820941)
(1.59881584260641 , 0.77138840549169)
(1.59881933326492 , 0.771386660162438)
(1.59882282392342 , 0.771384914833186)
(1.59882631458193 , 0.771383169503934)
(1.59882980524043 , 0.771381424174682)
(1.59883329589893 , 0.77137967884543)
(1.59883678655744 , 0.771377933516178)
(1.59884027721594 , 0.771376188186926)
(1.59884376787445 , 0.771374442857673)
(1.59884725853295 , 0.771372697528422)
(1.59885074919145 , 0.77137095219917)
(1.59885423984996 , 0.771369206869918)
(1.59885773050846 , 0.771367461540666)
(1.59886122116697 , 0.771365716211414)
(1.59886471182547 , 0.771363970882162)
(1.59886820248397 , 0.77136222555291)
(1.59887169314248 , 0.771360480223658)
(1.59887518380098 , 0.771358734894406)
(1.59887867445948 , 0.771356989565154)
(1.59888216511799 , 0.771355244235902)
(1.59888565577649 , 0.77135349890665)
(1.598889146435 , 0.771351753577398)
(1.5988926370935 , 0.771350008248146)
(1.59889612775201 , 0.771348262918894)
(1.59889961841051 , 0.771346517589642)
(1.59890310906901 , 0.77134477226039)
(1.59890659972752 , 0.771343026931138)
(1.59891009038602 , 0.771341281601886)
(1.59891358104452 , 0.771339536272634)
(1.59891707170303 , 0.771337790943382)
(1.59892056236153 , 0.77133604561413)
(1.59892405302004 , 0.771334300284878)
(1.59892754367854 , 0.771332554955626)
(1.59893103433705 , 0.771330809626374)
(1.59893452499555 , 0.771329064297122)
(1.59893801565405 , 0.77132731896787)
(1.59894150631256 , 0.771325573638618)
(1.59894499697106 , 0.771323828309366)
(1.59894848762957 , 0.771322082980114)
(1.59895197828807 , 0.771320337650862)
(1.59895546894657 , 0.77131859232161)
(3.61121537674092 , -1.33598496521933)
(3.61121886739942 , -1.33598321989008)
(3.61122235805792 , -1.33598147456083)
(3.61122584871643 , -1.33597972923158)
(3.61122933937493 , -1.33597798390233)
(3.61123283003344 , -1.33597623857307)
(3.61123632069194 , -1.33597449324382)
(3.61123981135044 , -1.33597274791457)
(3.61124330200895 , -1.33597100258532)
(3.61124679266745 , -1.33596925725607)
(3.61125028332595 , -1.33596751192682)
(3.61125377398446 , -1.33596576659756)
(3.61125726464296 , -1.33596402126831)
(3.61126075530147 , -1.33596227593906)
(3.61126424595997 , -1.33596053060981)
(3.61126773661847 , -1.33595878528056)
(3.61127122727698 , -1.3359570399513)
(3.61127471793548 , -1.33595529462205)
(3.61127820859399 , -1.3359535492928)
\.

CREATE OR REPLACE FUNCTION qnodes(q text) RETURNS text
LANGUAGE 'plpgsql' AS
$$
DECLARE
  exp TEXT;
  mat TEXT[];
  ret TEXT[];
BEGIN
  FOR exp IN EXECUTE 'EXPLAIN ' || q
  LOOP
    --RAISE NOTICE 'EXP: %', exp;
    mat := regexp_matches(exp, ' *(?:-> *)?(.*Scan on (test_points|brin_spoint))');
    --RAISE NOTICE 'MAT: %', mat;
    IF mat IS NOT NULL THEN
      ret := array_append(ret, mat[1]);
    END IF;
    --RAISE NOTICE 'RET: %', ret;
  END LOOP;
  RETURN array_to_string(ret,',');
END;
$$;

CREATE INDEX brin_spoint ON test_points USING brin (p) WITH (pages_per_range = 16);

set enable_indexscan = off;
set enable_bitmapscan = off;
set enable_seqscan = on;

SELECT 'scan_seq', qnodes('SELECT * FROM test_points WHERE p <@ sbox ''( (10d,10d), (20d,20d) )''');
SELECT * FROM test_points WHERE p <@ sbox '( (10d,10d), (20d,20d) )';

SELECT 'scan_seq', qnodes('SELECT * FROM test_points WHERE p && sbox ''( (10d,10d), (20d,20d) )''');
SELECT * FROM test_points WHERE p && sbox '( (10d,10d), (20d,20d) )';

set enable_indexscan = off;
set enable_bitmapscan = on;
set enable_seqscan = off;

SELECT 'scan_idx', qnodes('SELECT * FROM test_points WHERE p <@ sbox ''( (10d,10d), (20d,20d) )''');
SELECT * FROM test_points WHERE p <@ sbox '( (10d,10d), (20d,20d) )';

SELECT 'scan_idx', qnodes('SELECT * FROM test_points WHERE p && sbox ''( (10d,10d), (20d,20d) )''');
SELECT * FROM test_points WHERE p && sbox '( (10d,10d), (20d,20d) )';

-- cleanup
DROP INDEX brin_spoint;
DROP TABLE test_points;
DROP FUNCTION qnodes(text);

set enable_indexscan = on;
set enable_bitmapscan = on;
set enable_seqscan = on;
