/*******************************************************************************
 *
 * MIT License
 *
 * Copyright (c) 2024 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/
#include "ctc_driver.hpp"
#include "registry_driver_maker.hpp"
#include "rnn_driver.hpp"
#include "rnn_seq_driver.hpp"

static Driver* makeDriver(const std::string& base_arg)
{
    if(base_arg == "rnn_seq")
        return new RNNSeqDriver<float, double>();
    if(base_arg == "rnn_seqfp16")
        return new RNNSeqDriver<float16, double>();
    if(base_arg == "rnn")
        return new RNNDriver<float, double>();
    if(base_arg == "rnnfp16")
        return new RNNDriver<float16, double>();
    if(base_arg == "ctc")
        return new CTCDriver<float>();
    return nullptr;
}

REGISTER_DRIVER_MAKER(makeDriver);
