// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2015 Konrad Twardowski

#pragma once

#include <QFile>
#include <QTextStream>

class Log final {
public:
	static void error(const QString &text);
	static void info(const QString &text);
	static void init();
	static void shutDown();
	static void warning(const QString &text);
private:
	Q_DISABLE_COPY(Log)
	explicit Log() { }
	inline static bool terminal = false;
	inline static QFile *logFile = nullptr;
	inline static QTextStream *output = nullptr;
	static void log(const QString &category, const QString &text);
	static QString makeColor(const int color, const QString &text);
};
