/* gmp-mparam.h -- Compiler/machine parameter header file for a53.

Copyright 2019 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 64
#define GMP_LIMB_BYTES 8

/* 1536 MHz Cortex-A53 */
/* FFT tuning limit = 21,583,800 */
/* Generated by tuneup.c, 2019-10-22, gcc 5.4 */

#define DIVREM_1_NORM_THRESHOLD              3
#define DIVREM_1_UNNORM_THRESHOLD            4
#define MOD_1_1P_METHOD                      2  /* 4.84% faster than 1 */
#define MOD_1_NORM_THRESHOLD                 3
#define MOD_1_UNNORM_THRESHOLD               4
#define MOD_1N_TO_MOD_1_1_THRESHOLD          7
#define MOD_1U_TO_MOD_1_1_THRESHOLD          7
#define MOD_1_1_TO_MOD_1_2_THRESHOLD        12
#define MOD_1_2_TO_MOD_1_4_THRESHOLD        18
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD     22
#define USE_PREINV_DIVREM_1                  1
#define DIV_QR_1N_PI1_METHOD                 1  /* 39.05% faster than 2 */
#define DIV_QR_1_NORM_THRESHOLD             21
#define DIV_QR_1_UNNORM_THRESHOLD           21
#define DIV_QR_2_PI2_THRESHOLD           MP_SIZE_T_MAX  /* never */
#define DIVEXACT_1_THRESHOLD                 0  /* always */
#define BMOD_1_TO_MOD_1_THRESHOLD           38

#define DIV_1_VS_MUL_1_PERCENT             161

#define MUL_TOOM22_THRESHOLD                14
#define MUL_TOOM33_THRESHOLD                49
#define MUL_TOOM44_THRESHOLD                73
#define MUL_TOOM6H_THRESHOLD               173
#define MUL_TOOM8H_THRESHOLD               236

#define MUL_TOOM32_TO_TOOM43_THRESHOLD      81
#define MUL_TOOM32_TO_TOOM53_THRESHOLD      77
#define MUL_TOOM42_TO_TOOM53_THRESHOLD      81
#define MUL_TOOM42_TO_TOOM63_THRESHOLD      88
#define MUL_TOOM43_TO_TOOM54_THRESHOLD      65

#define SQR_BASECASE_THRESHOLD               0  /* always */
#define SQR_TOOM2_THRESHOLD                 18
#define SQR_TOOM3_THRESHOLD                 68
#define SQR_TOOM4_THRESHOLD                183
#define SQR_TOOM6_THRESHOLD                230
#define SQR_TOOM8_THRESHOLD                357

#define MULMID_TOOM42_THRESHOLD             23

#define MULMOD_BNM1_THRESHOLD                9
#define SQRMOD_BNM1_THRESHOLD               11

#define MUL_FFT_MODF_THRESHOLD             316  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    316, 5}, {     13, 6}, {      7, 5}, {     15, 6}, \
    {     13, 7}, {      7, 6}, {     15, 7}, {      8, 6}, \
    {     17, 7}, {      9, 6}, {     19, 7}, {     17, 8}, \
    {      9, 7}, {     20, 8}, {     11, 7}, {     23, 8}, \
    {     13, 9}, {      7, 8}, {     19, 9}, {     11, 8}, \
    {     27, 9}, {     15, 8}, {     33, 9}, {     19, 8}, \
    {     41, 9}, {     23, 8}, {     49, 9}, {     27,10}, \
    {     15, 9}, {     39,10}, {     23, 9}, {     51,11}, \
    {     15,10}, {     31, 9}, {     71,10}, {     39, 9}, \
    {     83,10}, {     47, 9}, {     99,10}, {     55,11}, \
    {     31,10}, {     63, 8}, {    255,10}, {     71, 8}, \
    {    287,10}, {     79, 9}, {    159, 8}, {    319,10}, \
    {     87,11}, {     47,10}, {     95, 9}, {    191, 8}, \
    {    383,10}, {    103, 9}, {    207, 8}, {    415,10}, \
    {    111, 9}, {    223,12}, {     31,11}, {     63, 9}, \
    {    255, 8}, {    511,10}, {    135, 9}, {    287, 8}, \
    {    575,11}, {     79,10}, {    159, 9}, {    319, 8}, \
    {    639,10}, {    175, 9}, {    351, 8}, {    703,11}, \
    {     95,10}, {    191, 9}, {    383, 8}, {    767,10}, \
    {    207, 9}, {    415, 8}, {    831,10}, {    223, 9}, \
    {    447,12}, {     63,10}, {    255, 9}, {    511, 8}, \
    {   1023, 9}, {    543,10}, {    287, 9}, {    575, 8}, \
    {   1151,11}, {    159,10}, {    319, 9}, {    639,11}, \
    {    175,10}, {    351, 9}, {    703, 8}, {   1407,12}, \
    {     95,11}, {    191,10}, {    383, 9}, {    767,11}, \
    {    207,10}, {    415, 9}, {    831,11}, {    223,10}, \
    {    447,13}, {     63,11}, {    255,10}, {    543,11}, \
    {    287,10}, {    575, 9}, {   1151,12}, {    159,11}, \
    {    319,10}, {    639,11}, {    351,10}, {    703, 9}, \
    {   1407, 8}, {   2815,12}, {    191,11}, {    383,10}, \
    {    767,11}, {    415,10}, {    831,12}, {    223,11}, \
    {    447,10}, {    895,11}, {    479,10}, {    959, 9}, \
    {   1919,12}, {    255,11}, {    511,10}, {   1023,11}, \
    {    543,10}, {   1087,12}, {    287,11}, {    575,10}, \
    {   1151,12}, {    319,11}, {    639,12}, {    351,11}, \
    {    703,10}, {   1407, 9}, {   2815,13}, {    191,12}, \
    {    383,11}, {    767,12}, {    415,11}, {    831,10}, \
    {   1663,12}, {    447,11}, {    895,10}, {   1791,12}, \
    {    479,11}, {    959,13}, {    255,12}, {    511,11}, \
    {   1023,12}, {    543,11}, {   1087,12}, {    575,11}, \
    {   1151,13}, {    319,12}, {    703,11}, {   1407,10}, \
    {   2815,13}, {    383,12}, {    831,11}, {   1663,13}, \
    {    447,12}, {    895,11}, {   1791,12}, {    959,11}, \
    {   1919,14}, {    255,13}, {    511,12}, {   1087,13}, \
    {    575,12}, {   1151,13}, {    703,12}, {   1407,11}, \
    {   2815,14}, {    383,13}, {    831,12}, {   1663,13}, \
    {    895,12}, {   1791,13}, {    959,12}, {   1919,15}, \
    {    255,14}, {    511,13}, {   1087,12}, {   2175,13}, \
    {   1215,14}, {    639,13}, {   1407,12}, {   2815,14}, \
    {    767,13}, {   1663,14}, {    895,13}, {   1919,12}, \
    {   3839,15}, {    511,14}, {   1023,13}, {   2175,14}, \
    {   1151,13}, {   2431,12}, {   4863,14}, {  16384,15}, \
    {  32768,16}, {  65536,17}, { 131072,18}, { 262144,19}, \
    { 524288,20}, {1048576,21}, {2097152,22}, {4194304,23}, \
    {8388608,24} }
#define MUL_FFT_TABLE3_SIZE 217
#define MUL_FFT_THRESHOLD                 3200

#define SQR_FFT_MODF_THRESHOLD             276  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    276, 5}, {     13, 6}, {      7, 5}, {     15, 6}, \
    {     17, 7}, {     17, 8}, {      9, 7}, {     20, 8}, \
    {     11, 7}, {     23, 8}, {     13, 9}, {      7, 8}, \
    {     15, 7}, {     31, 8}, {     19, 9}, {     11, 8}, \
    {     27, 9}, {     15, 8}, {     33, 9}, {     19, 8}, \
    {     39, 9}, {     23, 8}, {     47, 9}, {     27,10}, \
    {     15, 9}, {     39,10}, {     23, 9}, {     47,11}, \
    {     15,10}, {     31, 9}, {     67,10}, {     39, 9}, \
    {     79,10}, {     47, 9}, {     95, 8}, {    191,10}, \
    {     55,11}, {     31,10}, {     63, 8}, {    255,10}, \
    {     71, 9}, {    143, 8}, {    287,10}, {     79, 9}, \
    {    159,11}, {     47,10}, {     95, 9}, {    191, 8}, \
    {    383, 7}, {    767,10}, {    103,12}, {     31,11}, \
    {     63, 9}, {    255, 8}, {    511, 7}, {   1023,10}, \
    {    143, 9}, {    287,11}, {     79,10}, {    159, 9}, \
    {    319, 8}, {    639,10}, {    175, 9}, {    351, 8}, \
    {    703,11}, {     95,10}, {    191, 9}, {    383, 8}, \
    {    767,10}, {    207, 9}, {    415, 8}, {    831,10}, \
    {    223, 9}, {    447,12}, {     63,10}, {    255, 9}, \
    {    511, 8}, {   1023,11}, {    143,10}, {    287, 9}, \
    {    575, 8}, {   1151,11}, {    159,10}, {    319, 9}, \
    {    639,11}, {    175,10}, {    351, 9}, {    703,12}, \
    {     95,11}, {    191,10}, {    383, 9}, {    767,11}, \
    {    207,10}, {    415, 9}, {    831,11}, {    223,10}, \
    {    447,13}, {     63,11}, {    255,10}, {    511, 9}, \
    {   1023,11}, {    287,10}, {    575, 9}, {   1151,12}, \
    {    159,11}, {    319,10}, {    639,11}, {    351,10}, \
    {    703, 9}, {   1407,12}, {    191,11}, {    383,10}, \
    {    767,11}, {    415,10}, {    831,12}, {    223,11}, \
    {    447,10}, {    895,11}, {    479,10}, {    959,12}, \
    {    255,11}, {    511,10}, {   1023,12}, {    287,11}, \
    {    575,10}, {   1151,12}, {    319,11}, {    639,12}, \
    {    351,11}, {    703,10}, {   1407,13}, {    191,12}, \
    {    383,11}, {    767,12}, {    415,11}, {    831,10}, \
    {   1663,12}, {    447,11}, {    895,12}, {    479,11}, \
    {    959,10}, {   1919,13}, {    255,12}, {    511,11}, \
    {   1023,12}, {    543,11}, {   1087,12}, {    575,11}, \
    {   1151,13}, {    319,12}, {    703,11}, {   1407,10}, \
    {   2815,13}, {    383,12}, {    831,11}, {   1663,13}, \
    {    447,12}, {    895,11}, {   1791,12}, {    959,14}, \
    {    255,13}, {    511,12}, {   1087,13}, {    575,12}, \
    {   1151,13}, {    703,12}, {   1407,11}, {   2815,14}, \
    {    383,13}, {    831,12}, {   1663,13}, {    895,12}, \
    {   1791,13}, {    959,12}, {   1919,15}, {    255,14}, \
    {    511,13}, {   1087,12}, {   2175,13}, {   1151,14}, \
    {    639,13}, {   1407,12}, {   2815,14}, {    767,13}, \
    {   1663,14}, {    895,13}, {   1919,12}, {   3839,15}, \
    {    511,14}, {   1023,13}, {   2175,14}, {   1151,13}, \
    {   2431,12}, {   4863,14}, {  16384,15}, {  32768,16}, \
    {  65536,17}, { 131072,18}, { 262144,19}, { 524288,20}, \
    {1048576,21}, {2097152,22}, {4194304,23}, {8388608,24} }
#define SQR_FFT_TABLE3_SIZE 204
#define SQR_FFT_THRESHOLD                 2688

#define MULLO_BASECASE_THRESHOLD             0  /* always */
#define MULLO_DC_THRESHOLD                  38
#define MULLO_MUL_N_THRESHOLD             6253
#define SQRLO_BASECASE_THRESHOLD             4
#define SQRLO_DC_THRESHOLD                  67
#define SQRLO_SQR_THRESHOLD               5240

#define DC_DIV_QR_THRESHOLD                 43
#define DC_DIVAPPR_Q_THRESHOLD             155
#define DC_BDIV_QR_THRESHOLD                39
#define DC_BDIV_Q_THRESHOLD                 89

#define INV_MULMOD_BNM1_THRESHOLD           34
#define INV_NEWTON_THRESHOLD               163
#define INV_APPR_THRESHOLD                 161

#define BINV_NEWTON_THRESHOLD              196
#define REDC_1_TO_REDC_N_THRESHOLD          43

#define MU_DIV_QR_THRESHOLD                998
#define MU_DIVAPPR_Q_THRESHOLD             998
#define MUPI_DIV_QR_THRESHOLD               91
#define MU_BDIV_QR_THRESHOLD               807
#define MU_BDIV_Q_THRESHOLD                924

#define POWM_SEC_TABLE  6,30,125,579,1730

#define GET_STR_DC_THRESHOLD                15
#define GET_STR_PRECOMPUTE_THRESHOLD        30
#define SET_STR_DC_THRESHOLD               802
#define SET_STR_PRECOMPUTE_THRESHOLD      1815

#define FAC_DSC_THRESHOLD                  258
#define FAC_ODD_THRESHOLD                   24

#define MATRIX22_STRASSEN_THRESHOLD         10
#define HGCD2_DIV1_METHOD                    1  /* 7.05% faster than 3 */
#define HGCD_THRESHOLD                     107
#define HGCD_APPR_THRESHOLD                112
#define HGCD_REDUCE_THRESHOLD             1679
#define GCD_DC_THRESHOLD                   324
#define GCDEXT_DC_THRESHOLD                242
#define JACOBI_BASE_METHOD                   4  /* 22.41% faster than 1 */

/* Tuneup completed successfully, took 66624 seconds */
