import type zlib from "node:zlib";
import { Transform, type TransformOptions } from "node:stream";
export declare abstract class ZlibCompress extends Transform {
    readonly __unenv__ = true;
    readonly bytesRead = 0;
    readonly bytesWritten = 0;
    abstract readonly _format: undefined | "deflate" | "gzip" | "zlib" | "brotli" | "zip";
    constructor(opts?: TransformOptions);
    close(callback?: () => void): void;
    flush(kind?: number | undefined, callback?: (() => void) | undefined): void;
    flush(callback?: (() => void) | undefined): void;
}
export declare abstract class ZLibDecompress extends ZlibCompress {
}
export interface CompressFunction {
    (buf: zlib.InputType, options?: any, callback?: zlib.CompressCallback): void;
    (buf: Buffer, callback?: zlib.CompressCallback): void;
    __promisify__(buffer: zlib.InputType, options?: any): Promise<Buffer>;
}
export declare function notImplementedCompress(format: string): CompressFunction;
