"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ERR_INVALID_URL_SCHEME = exports.ERR_INVALID_URL = exports.ERR_INVALID_FILE_URL_PATH = exports.ERR_INVALID_FILE_URL_HOST = exports.ERR_INVALID_ARG_VALUE = exports.ERR_INVALID_ARG_TYPE = void 0;
function fmt(val) {
  if (Array.isArray(val)) {
    return val.map(v => fmt(v)).join(" or ");
  }
  if (!val) {
    return "" + val;
  }
  return val.toString();
}
class ERR_INVALID_ARG_VALUE extends TypeError {
  code = "ERR_INVALID_ARG_VALUE";
  constructor(name, value, reason) {
    super(`The ${name.includes(".") ? "property" : "argument"} '${name}' ${reason}. Received ${value}`);
  }
}
exports.ERR_INVALID_ARG_VALUE = ERR_INVALID_ARG_VALUE;
class ERR_INVALID_ARG_TYPE extends TypeError {
  code = "ERR_INVALID_ARG_TYPE";
  constructor(name, expected, actual) {
    super(`The "${name}" argument must be of type ${fmt(expected)}. Received ${fmt(actual)}`);
  }
}
exports.ERR_INVALID_ARG_TYPE = ERR_INVALID_ARG_TYPE;
class ERR_INVALID_URL extends TypeError {
  code = "ERR_INVALID_URL";
  input;
  base;
  constructor(input, base) {
    super("Invalid URL");
    this.input = input;
    if (base != null) {
      this.base = base;
    }
  }
}
exports.ERR_INVALID_URL = ERR_INVALID_URL;
class ERR_INVALID_URL_SCHEME extends TypeError {
  code = "ERR_INVALID_URL_SCHEME";
  constructor(expected) {
    super(`The URL must be of scheme ${expected}`);
  }
}
exports.ERR_INVALID_URL_SCHEME = ERR_INVALID_URL_SCHEME;
class ERR_INVALID_FILE_URL_PATH extends TypeError {
  code = "ERR_INVALID_FILE_URL_PATH";
  constructor(path) {
    super(`Invalid ile URL path: ${path}`);
  }
}
exports.ERR_INVALID_FILE_URL_PATH = ERR_INVALID_FILE_URL_PATH;
class ERR_INVALID_FILE_URL_HOST extends TypeError {
  code = "ERR_INVALID_FILE_URL_HOST";
  constructor(host) {
    super(`File URL host must be "localhost" or empty on ${host}`);
  }
}
exports.ERR_INVALID_FILE_URL_HOST = ERR_INVALID_FILE_URL_HOST;