"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WriteStream = void 0;
var _nodeNet = require("node:net");
class WriteStream extends _nodeNet.Socket {
  clearLine(dir, callback) {
    callback && callback();
    return false;
  }
  clearScreenDown(callback) {
    callback && callback();
    return false;
  }
  cursorTo(x, y, callback) {
    callback && typeof callback === "function" && callback();
    return false;
  }
  moveCursor(dx, dy, callback) {
    callback && callback();
    return false;
  }
  getColorDepth(env) {
    return 1;
  }
  hasColors(count, env) {
    return false;
  }
  getWindowSize() {
    return [this.columns, this.rows];
  }
  columns = 80;
  rows = 24;
  isTTY = false;
}
exports.WriteStream = WriteStream;