import { notImplemented } from "../../_internal/utils.mjs";
import noop from "../../mock/noop.mjs";
import promises from "./promises/index.mjs";
import { setTimeoutFallback } from "./internal/set-timeout.mjs";
import {
  setImmediateFallback,
  clearImmediateFallback
} from "./internal/set-immediate.mjs";
import { setIntervalFallback } from "./internal/set-interval.mjs";
export * as promises from "./promises/index.mjs";
export const clearImmediate = globalThis.clearImmediate || clearImmediateFallback;
export const clearInterval = globalThis.clearInterval || noop;
export const clearTimeout = globalThis.clearTimeout || noop;
export const setImmediate = globalThis.setImmediate || setImmediateFallback;
export const setTimeout = globalThis.setTimeout || setTimeoutFallback;
export const setInterval = globalThis.setInterval || setIntervalFallback;
export const active = notImplemented("timers.active");
export const _unrefActive = notImplemented("timers._unrefActive");
export const enroll = notImplemented("timers.enroll");
export const unenroll = notImplemented("timers.unenroll");
export default {
  _unrefActive,
  active,
  clearImmediate,
  clearInterval,
  clearTimeout,
  enroll,
  promises,
  setImmediate,
  setInterval,
  setTimeout,
  unenroll
};
