import { IntervalHistogram, RecordableHistogram } from "./internal/histogram.mjs";
import { constants } from "./internal/constants.mjs";
import {
  performance,
  Performance,
  PerformanceEntry,
  PerformanceMark,
  PerformanceMeasure,
  PerformanceObserverEntryList,
  PerformanceObserver,
  PerformanceResourceTiming
} from "./internal/performance.mjs";
export { constants } from "./internal/constants.mjs";
export * from "./internal/performance.mjs";
export const monitorEventLoopDelay = function(_options) {
  return new IntervalHistogram();
};
export const createHistogram = function(_options) {
  return new RecordableHistogram();
};
export default {
  Performance,
  PerformanceEntry,
  PerformanceMark,
  PerformanceMeasure,
  // @ts-expect-error TODO: resolve type-mismatch between web and node PerformanceObserverEntryList
  PerformanceObserverEntryList,
  PerformanceObserver,
  // @ts-expect-error TODO: resolve type-mismatch between web and node PerformanceObserverEntryList
  PerformanceResourceTiming,
  constants,
  createHistogram,
  monitorEventLoopDelay,
  performance
};
