export {
  Performance,
  PerformanceEntry,
  PerformanceMark,
  PerformanceMeasure,
  PerformanceObserverEntryList,
  PerformanceObserver,
  PerformanceResourceTiming,
  constants,
  createHistogram,
  monitorEventLoopDelay
} from "./index.mjs";
import {
  Performance as Performance2,
  PerformanceEntry as PerformanceEntry2,
  PerformanceMark as PerformanceMark2,
  PerformanceMeasure as PerformanceMeasure2,
  PerformanceObserverEntryList as PerformanceObserverEntryList2,
  PerformanceObserver as PerformanceObserver2,
  PerformanceResourceTiming as PerformanceResourceTiming2,
  constants as constants2,
  createHistogram as createHistogram2,
  monitorEventLoopDelay as monitorEventLoopDelay2,
  performance as unenvPerformance
} from "./index.mjs";
const workerdGlobalPerformance = globalThis["performance"];
export const performance = Object.assign(workerdGlobalPerformance, {
  // @ts-expect-error undocumented public API
  addEventListener: unenvPerformance.addEventListener.bind(unenvPerformance),
  clearMarks: unenvPerformance.clearMarks.bind(unenvPerformance),
  clearMeasures: unenvPerformance.clearMeasures.bind(unenvPerformance),
  clearResourceTimings: unenvPerformance.clearResourceTimings.bind(unenvPerformance),
  // @ts-expect-error undocumented public API
  dispatchEvent: unenvPerformance.dispatchEvent.bind(unenvPerformance),
  eventLoopUtilization: unenvPerformance.eventLoopUtilization.bind(unenvPerformance),
  getEntries: unenvPerformance.getEntries.bind(unenvPerformance),
  getEntriesByName: unenvPerformance.getEntriesByName.bind(unenvPerformance),
  getEntriesByType: unenvPerformance.getEntriesByType.bind(unenvPerformance),
  mark: unenvPerformance.mark.bind(unenvPerformance),
  markResourceTiming: unenvPerformance.markResourceTiming.bind(unenvPerformance),
  measure: unenvPerformance.measure.bind(unenvPerformance),
  nodeTiming: { ...unenvPerformance.nodeTiming },
  onresourcetimingbufferfull: (
    // @ts-expect-error undocumented public API
    typeof unenvPerformance.onresourcetimingbufferfull === "function" ? (
      // @ts-expect-error undocumented public API
      unenvPerformance.onresourcetimingbufferfull.bind(unenvPerformance)
    ) : (
      // @ts-expect-error undocumented public API
      unenvPerformance.onresourcetimingbufferfull
    )
  ),
  removeEventListener: (
    // @ts-expect-error undocumented public API
    unenvPerformance.removeEventListener.bind(unenvPerformance)
  ),
  setResourceTimingBufferSize: unenvPerformance.setResourceTimingBufferSize.bind(unenvPerformance),
  timerify: unenvPerformance.timerify.bind(unenvPerformance),
  toJSON: unenvPerformance.toJSON.bind(unenvPerformance)
});
export default {
  /**
   * manually unroll unenv-polyfilled-symbols to make it tree-shakeable
   */
  Performance: Performance2,
  PerformanceEntry: PerformanceEntry2,
  PerformanceMark: PerformanceMark2,
  PerformanceMeasure: PerformanceMeasure2,
  // @ts-expect-error TODO: resolve type-mismatch between web and node PerformanceObserverEntryList
  PerformanceObserverEntryList: PerformanceObserverEntryList2,
  PerformanceObserver: PerformanceObserver2,
  // @ts-expect-error TODO: resolve type-mismatch between web and node PerformanceObserverEntryList
  PerformanceResourceTiming: PerformanceResourceTiming2,
  constants: constants2,
  createHistogram: createHistogram2,
  monitorEventLoopDelay: monitorEventLoopDelay2,
  /**
   * manually unroll workerd-polyfilled-symbols to make it tree-shakeable
   */
  performance
};
