"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrap = exports.syncBuiltinESMExports = exports.runMain = exports.register = exports.isBuiltin = exports.globalPaths = exports.getCompileCacheDir = exports.flushCompileCache = exports.findSourceMap = exports.enableCompileCache = exports.default = exports.createRequire = exports.constants = exports.builtinModules = exports._resolveLookupPaths = exports._resolveFilename = exports._preloadModules = exports._pathCache = exports._nodeModulePaths = exports._load = exports._initPaths = exports._findPath = exports._extensions = exports._debug = exports._cache = exports._Module = exports.SourceMap = exports.Module = void 0;
var _utils = require("../../_internal/utils.cjs");
const _cache = exports._cache = /* @__PURE__ */Object.create(null);
const _extensions = exports._extensions = {
  ".js": (0, _utils.notImplemented)("module.require.extensions['.js']"),
  ".json": (0, _utils.notImplemented)("module.require.extensions['.json']"),
  ".node": (0, _utils.notImplemented)("module.require.extensions['.node']")
};
const createRequire = function (filename) {
  return Object.assign((0, _utils.notImplemented)("module.require"), {
    resolve: Object.assign((0, _utils.notImplemented)("module.require.resolve"), {
      paths: (0, _utils.notImplemented)("module.require.resolve.paths")
    }),
    cache: /* @__PURE__ */Object.create(null),
    extensions: _extensions,
    main: void 0
  });
};
exports.createRequire = createRequire;
const getCompileCacheDir = function () {
  return void 0;
};
exports.getCompileCacheDir = getCompileCacheDir;
const enableCompileCache = function (caheDir) {
  return {
    status: 0,
    message: "not implemented"
  };
};
exports.enableCompileCache = enableCompileCache;
const constants = exports.constants = Object.freeze({
  compileCacheStatus: Object.freeze({
    FAILED: 0,
    ENABLED: 1,
    ALREADY_ENABLED: 2,
    DISABLED: 3
  })
});
const builtinModules = exports.builtinModules = ["_http_agent", "_http_client", "_http_common", "_http_incoming", "_http_outgoing", "_http_server", "_stream_duplex", "_stream_passthrough", "_stream_readable", "_stream_transform", "_stream_wrap", "_stream_writable", "_tls_common", "_tls_wrap", "assert", "assert/strict", "async_hooks", "buffer", "child_process", "cluster", "console", "constants", "crypto", "dgram", "diagnostics_channel", "dns", "dns/promises", "domain", "events", "fs", "fs/promises", "http", "http2", "https", "inspector", "inspector/promises", "module", "net", "os", "path", "path/posix", "path/win32", "perf_hooks", "process", "punycode", "querystring", "readline", "readline/promises", "repl", "stream", "stream/consumers", "stream/promises", "stream/web", "string_decoder", "sys", "timers", "timers/promises", "tls", "trace_events", "tty", "url", "util", "util/types", "v8", "vm", "wasi", "worker_threads", "zlib"];
const isBuiltin = function (id) {
  return id.startsWith("node:") || builtinModules.includes(id);
};
exports.isBuiltin = isBuiltin;
const runMain = exports.runMain = (0, _utils.notImplemented)("module.runMain");
const register = exports.register = (0, _utils.notImplemented)("module.register");
const syncBuiltinESMExports = function () {
  return [];
};
exports.syncBuiltinESMExports = syncBuiltinESMExports;
const findSourceMap = function (path, error) {
  return void 0;
};
exports.findSourceMap = findSourceMap;
const flushCompileCache = exports.flushCompileCache = function flushCompileCache2() {};
const wrap = function (source) {
  return `(function (exports, require, module, __filename, __dirname) { ${source}
});`;
};
exports.wrap = wrap;
const SourceMap = exports.SourceMap = (0, _utils.notImplementedClass)("module.SourceMap");
const _debug = exports._debug = console.debug;
const _findPath = exports._findPath = (0, _utils.notImplemented)("module._findPath");
const _initPaths = exports._initPaths = (0, _utils.notImplemented)("module._initPaths");
const _load = exports._load = (0, _utils.notImplemented)("module._load");
const _nodeModulePaths = exports._nodeModulePaths = (0, _utils.notImplemented)("module._nodeModulePaths");
const _preloadModules = exports._preloadModules = (0, _utils.notImplemented)("module._preloadModules");
const _resolveFilename = exports._resolveFilename = (0, _utils.notImplemented)("module._resolveFilename");
const _resolveLookupPaths = exports._resolveLookupPaths = (0, _utils.notImplemented)("module._resolveLookupPaths");
const _pathCache = exports._pathCache = /* @__PURE__ */Object.create(null);
const globalPaths = exports.globalPaths = ["node_modules"];
class _Module {
  require;
  id;
  filename;
  exports = /* @__PURE__ */Object.create(null);
  parent = void 0;
  loaded = true;
  children = [];
  isPreloading = false;
  path = "/";
  paths = [];
  constructor(id = "index.js") {
    this.id = id;
    this.filename = id;
    this.require = createRequire(id);
  }
}
exports._Module = _Module;
const Module = exports.Module = {
  get Module() {
    return Module;
  },
  SourceMap,
  _cache,
  _extensions,
  _debug,
  _pathCache,
  _findPath,
  _initPaths,
  _load,
  _nodeModulePaths,
  _preloadModules,
  _resolveFilename,
  _resolveLookupPaths,
  builtinModules,
  constants,
  createRequire,
  enableCompileCache,
  findSourceMap,
  getCompileCacheDir,
  globalPaths,
  isBuiltin,
  register,
  runMain,
  syncBuiltinESMExports,
  wrap,
  flushCompileCache
};
module.exports = Module;