export {
  Cipher,
  Cipheriv,
  Decipher,
  Decipheriv,
  ECDH,
  Sign,
  Verify,
  constants,
  createCipheriv,
  createDecipheriv,
  createECDH,
  createSign,
  createVerify,
  diffieHellman,
  getCipherInfo,
  hash,
  privateDecrypt,
  privateEncrypt,
  publicDecrypt,
  publicEncrypt,
  sign,
  verify
} from "./index.mjs";
import {
  Cipher as Cipher2,
  Cipheriv as Cipheriv2,
  Decipher as Decipher2,
  Decipheriv as Decipheriv2,
  ECDH as ECDH2,
  Sign as Sign2,
  Verify as Verify2,
  constants as constants2,
  createCipheriv as createCipheriv2,
  createDecipheriv as createDecipheriv2,
  createECDH as createECDH2,
  createSign as createSign2,
  createVerify as createVerify2,
  diffieHellman as diffieHellman2,
  getCipherInfo as getCipherInfo2,
  hash as hash2,
  privateDecrypt as privateDecrypt2,
  privateEncrypt as privateEncrypt2,
  publicDecrypt as publicDecrypt2,
  publicEncrypt as publicEncrypt2,
  sign as sign2,
  verify as verify2,
  webcrypto as unenvCryptoWebcrypto
} from "./index.mjs";
const workerdCrypto = process.getBuiltinModule("node:crypto");
export const {
  Certificate,
  DiffieHellman,
  DiffieHellmanGroup,
  Hash,
  Hmac,
  KeyObject,
  X509Certificate,
  checkPrime,
  checkPrimeSync,
  createDiffieHellman,
  createDiffieHellmanGroup,
  createHash,
  createHmac,
  createPrivateKey,
  createPublicKey,
  createSecretKey,
  generateKey,
  generateKeyPair,
  generateKeyPairSync,
  generateKeySync,
  generatePrime,
  generatePrimeSync,
  getCiphers,
  getCurves,
  getDiffieHellman,
  getFips,
  getHashes,
  hkdf,
  hkdfSync,
  pbkdf2,
  pbkdf2Sync,
  randomBytes,
  randomFill,
  randomFillSync,
  randomInt,
  randomUUID,
  scrypt,
  scryptSync,
  secureHeapUsed,
  setEngine,
  setFips,
  subtle,
  timingSafeEqual
} = workerdCrypto;
export const getRandomValues = workerdCrypto.getRandomValues.bind(
  workerdCrypto.webcrypto
);
export const webcrypto = {
  CryptoKey: unenvCryptoWebcrypto.CryptoKey,
  getRandomValues,
  randomUUID,
  subtle
};
const fips = workerdCrypto.fips;
import { createCipher, createDecipher, pseudoRandomBytes } from "./index.mjs";
export default {
  /**
   * manually unroll unenv-polyfilled-symbols to make it tree-shakeable
   */
  Certificate,
  Cipher: Cipher2,
  Cipheriv: Cipheriv2,
  Decipher: Decipher2,
  Decipheriv: Decipheriv2,
  ECDH: ECDH2,
  Sign: Sign2,
  Verify: Verify2,
  X509Certificate,
  // @ts-expect-error @types/node is out of date - this is a bug in typings
  constants: constants2,
  createCipheriv: createCipheriv2,
  createDecipheriv: createDecipheriv2,
  createECDH: createECDH2,
  createSign: createSign2,
  createVerify: createVerify2,
  diffieHellman: diffieHellman2,
  getCipherInfo: getCipherInfo2,
  hash: hash2,
  privateDecrypt: privateDecrypt2,
  privateEncrypt: privateEncrypt2,
  publicDecrypt: publicDecrypt2,
  publicEncrypt: publicEncrypt2,
  scrypt,
  scryptSync,
  sign: sign2,
  verify: verify2,
  // default-only export from unenv
  createCipher,
  createDecipher,
  pseudoRandomBytes,
  /**
   * manually unroll workerd-polyfilled-symbols to make it tree-shakeable
   */
  DiffieHellman,
  DiffieHellmanGroup,
  Hash,
  Hmac,
  KeyObject,
  checkPrime,
  checkPrimeSync,
  createDiffieHellman,
  createDiffieHellmanGroup,
  createHash,
  createHmac,
  createPrivateKey,
  createPublicKey,
  createSecretKey,
  generateKey,
  generateKeyPair,
  generateKeyPairSync,
  generateKeySync,
  generatePrime,
  generatePrimeSync,
  getCiphers,
  getCurves,
  getDiffieHellman,
  getFips,
  getHashes,
  getRandomValues,
  hkdf,
  hkdfSync,
  pbkdf2,
  pbkdf2Sync,
  randomBytes,
  randomFill,
  randomFillSync,
  randomInt,
  randomUUID,
  secureHeapUsed,
  setEngine,
  setFips,
  subtle,
  timingSafeEqual,
  // default-only export from workerd
  fips,
  // special-cased deep merged symbols
  webcrypto
};
