"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.workers = exports.setupPrimary = exports.setupMaster = exports.settings = exports.schedulingPolicy = exports.isWorker = exports.isPrimary = exports.isMaster = exports.fork = exports.disconnect = exports.default = exports._maxListeners = exports._eventsCount = exports._events = exports.Worker = exports.SCHED_RR = exports.SCHED_NONE = void 0;
var _proxy = _interopRequireDefault(require("../../mock/proxy.cjs"));
var _utils = require("../../_internal/utils.cjs");
var _nodeEvents = require("node:events");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SCHED_NONE = exports.SCHED_NONE = 1;
const SCHED_RR = exports.SCHED_RR = 2;
const isMaster = exports.isMaster = true;
const isPrimary = exports.isPrimary = true;
const isWorker = exports.isWorker = false;
const schedulingPolicy = exports.schedulingPolicy = SCHED_RR;
const settings = exports.settings = {};
const workers = exports.workers = {};
const fork = exports.fork = (0, _utils.notImplemented)("cluster.fork");
const disconnect = exports.disconnect = (0, _utils.notImplemented)("cluster.disconnect");
const setupPrimary = exports.setupPrimary = (0, _utils.notImplemented)("cluster.setupPrimary");
const setupMaster = exports.setupMaster = (0, _utils.notImplemented)("cluster.setupMaster");
const _events = exports._events = [];
const _eventsCount = exports._eventsCount = 0;
const _maxListeners = exports._maxListeners = 0;
class Worker extends _nodeEvents.EventEmitter {
  _connected = false;
  id = 0;
  get process() {
    return _proxy.default.process;
  }
  get exitedAfterDisconnect() {
    return this._connected;
  }
  isConnected() {
    return this._connected;
  }
  isDead() {
    return true;
  }
  send(message, sendHandle, options, callback) {
    return false;
  }
  kill(signal) {
    this._connected = false;
  }
  destroy(signal) {
    this._connected = false;
  }
  disconnect() {
    this._connected = false;
  }
}
exports.Worker = Worker;
class _Cluster extends _nodeEvents.EventEmitter {
  worker = void 0;
  Worker = Worker;
  isMaster = isMaster;
  isPrimary = isPrimary;
  isWorker = isWorker;
  SCHED_NONE = SCHED_NONE;
  SCHED_RR = SCHED_RR;
  schedulingPolicy = SCHED_RR;
  settings = settings;
  workers = workers;
  setupPrimary() {
    return setupPrimary();
  }
  setupMaster() {
    return setupPrimary();
  }
  disconnect() {
    return disconnect();
  }
  fork() {
    return fork();
  }
}
module.exports = new _Cluster();