/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.HueColorKt;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.SRGB;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 '2\u00020\u0001:\u0001'B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B'\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\b\u0012\u0006\u0010\u0005\u001a\u00020\b\u0012\b\b\u0002\u0010\u0006\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\b2\b\b\u0002\u0010\u0004\u001a\u00020\b2\b\b\u0002\u0010\u0005\u001a\u00020\b2\b\b\u0002\u0010\u0006\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0000H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lcom/github/ajalt/colormath/model/HSL;", "Lcom/github/ajalt/colormath/HueColor;", "h", "", "s", "l", "alpha", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "", "(FFFF)V", "getAlpha", "()F", "getH", "getL", "getS", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "getSpace", "()Lcom/github/ajalt/colormath/ColorSpace;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toArray", "", "toHSL", "toHSV", "Lcom/github/ajalt/colormath/model/HSV;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toString", "", "Companion", "colormath"})
public final class HSL
implements HueColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float h;
    private final float s;
    private final float l;
    private final float alpha;
    @NotNull
    private static final List<ColorComponentInfo> components = ColorSpaceUtilsKt.polarComponentInfo("HSL");

    public HSL(float h, float s, float l, float alpha) {
        this.h = h;
        this.s = s;
        this.l = l;
        this.alpha = alpha;
    }

    public /* synthetic */ HSL(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    @Override
    public float getH() {
        return this.h;
    }

    public final float getS() {
        return this.s;
    }

    public final float getL() {
        return this.l;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public HSL(@NotNull Number h, @NotNull Number s, @NotNull Number l, @NotNull Number alpha) {
        Intrinsics.checkNotNullParameter(h, "h");
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(alpha, "alpha");
        this(h.floatValue(), s.floatValue(), l.floatValue(), alpha.floatValue());
    }

    public /* synthetic */ HSL(Number number, Number number2, Number number3, Number number4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            number4 = Float.valueOf(1.0f);
        }
        this(number, number2, number3, number4);
    }

    @NotNull
    public ColorSpace<HSL> getSpace() {
        return Companion;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        if ((double)this.s < 1.0E-7) {
            return RGB.Companion.invoke(this.l, this.l, this.l, this.getAlpha());
        }
        double h = (double)InternalMathKt.normalizeDeg(HueColorKt.hueOr(this, 0)) / 30.0;
        double s = this.s;
        double l = this.l;
        return SRGB.INSTANCE.invoke(HSL.toSRGB$f(h, s, l, 0), HSL.toSRGB$f(h, s, l, 8), HSL.toSRGB$f(h, s, l, 4), this.getAlpha());
    }

    @Override
    @NotNull
    public HSV toHSV() {
        float s = this.s;
        float l = this.l;
        float smin = s;
        float lmin = Math.max(l, 0.01f);
        float v = (l + (s *= (l *= (float)2) <= 1.0f ? l : (float)2 - l)) / (float)2;
        float sv = l == 0.0f ? (float)2 * (smin *= lmin <= 1.0f ? lmin : (float)2 - lmin) / (lmin + smin) : (float)2 * s / (l + s);
        return new HSV(this.getH(), sv, v, this.getAlpha());
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.getH(), this.s, this.l, this.getAlpha()};
        return fArray;
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return HueColor.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return HueColor.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return HueColor.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return HueColor.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return HueColor.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return HueColor.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return HueColor.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return HueColor.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return HueColor.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return HueColor.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return HueColor.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return HueColor.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return HueColor.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return HueColor.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return HueColor.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return HueColor.DefaultImpls.toHPLuv(this);
    }

    public final float component1() {
        return this.h;
    }

    public final float component2() {
        return this.s;
    }

    public final float component3() {
        return this.l;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final HSL copy(float h, float s, float l, float alpha) {
        return new HSL(h, s, l, alpha);
    }

    public static /* synthetic */ HSL copy$default(HSL hSL, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = hSL.h;
        }
        if ((n & 2) != 0) {
            f2 = hSL.s;
        }
        if ((n & 4) != 0) {
            f3 = hSL.l;
        }
        if ((n & 8) != 0) {
            f4 = hSL.alpha;
        }
        return hSL.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "HSL(h=" + this.h + ", s=" + this.s + ", l=" + this.l + ", alpha=" + this.alpha + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.h);
        result2 = result2 * 31 + Float.hashCode(this.s);
        result2 = result2 * 31 + Float.hashCode(this.l);
        result2 = result2 * 31 + Float.hashCode(this.alpha);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HSL)) {
            return false;
        }
        HSL hSL = (HSL)other;
        if (Float.compare(this.h, hSL.h) != 0) {
            return false;
        }
        if (Float.compare(this.s, hSL.s) != 0) {
            return false;
        }
        if (Float.compare(this.l, hSL.l) != 0) {
            return false;
        }
        return Float.compare(this.alpha, hSL.alpha) == 0;
    }

    private static final float toSRGB$f(double h, double s, double l, int n) {
        double k = ((double)n + h) % 12.0;
        double a = s * Math.min(l, 1.0 - l);
        return (float)(l - a * RangesKt.coerceAtLeast(Math.min(k - (double)3, Math.min((double)9 - k, 1.0)), -1.0));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/github/ajalt/colormath/model/HSL$Companion;", "Lcom/github/ajalt/colormath/ColorSpace;", "Lcom/github/ajalt/colormath/model/HSL;", "()V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "convert", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "colormath"})
    @SourceDebugExtension(value={"SMAP\nHSL.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HSL.kt\ncom/github/ajalt/colormath/model/HSL$Companion\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n23#2:69\n12#2,13:70\n1#3:83\n*S KotlinDebug\n*F\n+ 1 HSL.kt\ncom/github/ajalt/colormath/model/HSL$Companion\n*L\n26#1:69\n26#1:70,13\n26#1:83\n*E\n"})
    public static final class Companion
    implements ColorSpace<HSL> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getName() {
            return "HSL";
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return components;
        }

        @Override
        @NotNull
        public HSL convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return color.toHSL();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public HSL create(@NotNull float[] components) {
            void p3;
            void p2;
            void p1;
            float f;
            Intrinsics.checkNotNullParameter(components, "components");
            ColorSpace $this$doCreate$iv = this;
            boolean $i$f$doCreate = false;
            ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
            boolean $i$f$withValidComps = false;
            int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
            int n = size$iv$iv - 1;
            int n2 = components.length;
            if (!(n <= n2 ? n2 <= size$iv$iv : false)) {
                boolean bl = false;
                String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
                throw new IllegalArgumentException(string.toString());
            }
            float[] it$iv = components;
            boolean bl = false;
            float f2 = components[0];
            float f3 = components[1];
            float f4 = components[2];
            int n3 = 3;
            float[] fArray = components;
            if (n3 <= ArraysKt.getLastIndex(fArray)) {
                f = fArray[n3];
            } else {
                int n4 = n3;
                float f5 = f4;
                float f6 = f3;
                float f7 = f2;
                boolean bl2 = false;
                float f8 = 1.0f;
                f2 = f7;
                f3 = f6;
                f4 = f5;
                f = f8;
            }
            float f9 = f;
            float f10 = f4;
            float f11 = f3;
            float p0 = f2;
            boolean bl3 = false;
            return (HSL)((Color)new HSL(p0, (float)p1, (float)p2, (float)p3));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

