"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert = __importStar(require("assert"));
const fs_1 = require("fs");
const path = __importStar(require("path"));
const typescript_1 = __importDefault(require("typescript"));
const documents_1 = require("../../../../src/lib/documents");
const ls_config_1 = require("../../../../src/ls-config");
const DiagnosticsProvider_1 = require("../../../../src/plugins/typescript/features/DiagnosticsProvider");
const LSAndTSDocResolver_1 = require("../../../../src/plugins/typescript/LSAndTSDocResolver");
const service_1 = require("../../../../src/plugins/typescript/service");
const utils_1 = require("../../../../src/utils");
const test_utils_1 = require("../test-utils");
const testDir = path.join(__dirname, '..', 'testfiles', 'diagnostics');
describe('DiagnosticsProvider', function () {
    (0, test_utils_1.serviceWarmup)(this, testDir);
    function setup(filename) {
        const docManager = new documents_1.DocumentManager((textDocument) => new documents_1.Document(textDocument.uri, textDocument.text));
        const lsAndTsDocResolver = new LSAndTSDocResolver_1.LSAndTSDocResolver(docManager, [(0, utils_1.pathToUrl)(testDir)], new ls_config_1.LSConfigManager());
        const plugin = new DiagnosticsProvider_1.DiagnosticsProviderImpl(lsAndTsDocResolver, new ls_config_1.LSConfigManager());
        const filePath = path.join(testDir, filename);
        const document = docManager.openClientDocument({
            uri: (0, utils_1.pathToUrl)(filePath),
            text: typescript_1.default.sys.readFile(filePath) || ''
        });
        return { plugin, document, docManager, lsAndTsDocResolver };
    }
    it('notices creation and deletion of imported module', async () => {
        const { plugin, document, lsAndTsDocResolver } = setup('unresolvedimport.svelte');
        const diagnostics1 = await plugin.getDiagnostics(document);
        assert.deepStrictEqual(diagnostics1.length, 1);
        // back-and-forth-conversion normalizes slashes
        const newFilePath = (0, utils_1.normalizePath)(path.join(testDir, 'doesntexistyet.js')) || '';
        (0, fs_1.writeFileSync)(newFilePath, 'export default function foo() {}');
        assert.ok((0, fs_1.existsSync)(newFilePath));
        await lsAndTsDocResolver.invalidateModuleCache([newFilePath]);
        try {
            const diagnostics2 = await plugin.getDiagnostics(document);
            assert.deepStrictEqual(diagnostics2.length, 0);
            await lsAndTsDocResolver.deleteSnapshot(newFilePath);
        }
        finally {
            (0, fs_1.unlinkSync)(newFilePath);
        }
        const diagnostics3 = await plugin.getDiagnostics(document);
        assert.deepStrictEqual(diagnostics3.length, 1);
    }).timeout(this.timeout() * 2.5);
    it('notices changes of module resolution because of new file', async () => {
        const { plugin, document, lsAndTsDocResolver } = setup('unresolvedimport.svelte');
        const diagnostics1 = await plugin.getDiagnostics(document);
        assert.deepStrictEqual(diagnostics1.length, 1);
        // back-and-forth-conversion normalizes slashes
        const newFilePath = (0, utils_1.normalizePath)(path.join(testDir, 'doesntexistyet.js')) || '';
        const newTsFilePath = (0, utils_1.normalizePath)(path.join(testDir, 'doesntexistyet.ts')) || '';
        (0, fs_1.writeFileSync)(newFilePath, 'export function foo() {}');
        assert.ok((0, fs_1.existsSync)(newFilePath));
        await lsAndTsDocResolver.invalidateModuleCache([newFilePath]);
        try {
            const diagnostics2 = await plugin.getDiagnostics(document);
            assert.deepStrictEqual(diagnostics2[0].code, 2613);
        }
        catch (e) {
            (0, fs_1.unlinkSync)(newFilePath);
            throw e;
        }
        (0, fs_1.writeFileSync)(newTsFilePath, 'export default function foo() {}');
        assert.ok((0, fs_1.existsSync)(newTsFilePath));
        await lsAndTsDocResolver.invalidateModuleCache([newTsFilePath]);
        try {
            const diagnostics3 = await plugin.getDiagnostics(document);
            assert.deepStrictEqual(diagnostics3.length, 1);
            await lsAndTsDocResolver.deleteSnapshot(newTsFilePath);
        }
        finally {
            (0, fs_1.unlinkSync)(newTsFilePath);
            (0, fs_1.unlinkSync)(newFilePath);
        }
    }).timeout(this.timeout() * 2.5);
    it('notices update of imported module', async () => {
        const { plugin, document, lsAndTsDocResolver } = setup('diagnostics-imported-js-update.svelte');
        const newFilePath = (0, utils_1.normalizePath)(path.join(testDir, 'empty-export.ts')) || '';
        await lsAndTsDocResolver.getOrCreateSnapshot(newFilePath);
        const diagnostics1 = await plugin.getDiagnostics(document);
        assert.deepStrictEqual(diagnostics1[0]?.message, "Module '\"./empty-export\"' has no exported member 'foo'.");
        await lsAndTsDocResolver.updateExistingTsOrJsFile(newFilePath, [
            {
                range: { start: { line: 0, character: 0 }, end: { line: 0, character: 0 } },
                text: 'export function foo() {}'
            }
        ]);
        const diagnostics2 = await plugin.getDiagnostics(document);
        assert.deepStrictEqual(diagnostics2.length, 0);
        await lsAndTsDocResolver.deleteSnapshot(newFilePath);
    }).timeout(this.timeout() * 2.5);
    it('notices file changes in all services that reference that file', async () => {
        // Hacky but ensures that this tests is not interfered with by other tests
        // which could make it fail.
        (0, service_1.__resetCache)();
        const { plugin, document, docManager, lsAndTsDocResolver } = setup('different-ts-service.svelte');
        const otherFilePath = path.join(testDir, 'different-ts-service', 'different-ts-service.svelte');
        const otherDocument = docManager.openClientDocument({
            uri: (0, utils_1.pathToUrl)(otherFilePath),
            text: typescript_1.default.sys.readFile(otherFilePath) || ''
        });
        // needed because tests have nasty dependencies between them. The ts service
        // is cached and knows the docs already
        const sharedFilePath = path.join(testDir, 'shared-comp.svelte');
        docManager.openClientDocument({
            uri: (0, utils_1.pathToUrl)(sharedFilePath),
            text: typescript_1.default.sys.readFile(sharedFilePath) || ''
        });
        const diagnostics1 = await plugin.getDiagnostics(document);
        assert.deepStrictEqual(diagnostics1.length, 2);
        const diagnostics2 = await plugin.getDiagnostics(otherDocument);
        assert.deepStrictEqual(diagnostics2.length, 2);
        docManager.updateDocument({ uri: (0, utils_1.pathToUrl)(path.join(testDir, 'shared-comp.svelte')), version: 2 }, [
            {
                range: { start: { line: 1, character: 19 }, end: { line: 1, character: 19 } },
                text: 'o'
            }
        ]);
        await lsAndTsDocResolver.updateExistingTsOrJsFile(path.join(testDir, 'shared-ts-file.ts'), [
            {
                range: { start: { line: 0, character: 18 }, end: { line: 0, character: 18 } },
                text: 'r'
            }
        ]);
        // Wait until the LsAndTsDocResolver notifies the services of the document update
        await new Promise((resolve) => setTimeout(resolve, 1000));
        const diagnostics3 = await plugin.getDiagnostics(document);
        assert.deepStrictEqual(diagnostics3.length, 0);
        const diagnostics4 = await plugin.getDiagnostics(otherDocument);
        assert.deepStrictEqual(diagnostics4.length, 0);
    }).timeout(this.timeout() * 2.5);
});
//# sourceMappingURL=DiagnosticsProvider.test.js.map