/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.io;

import com.sun.corba.ee.impl.misc.ClassInfoCache;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;

class ObjectStreamClassCorbaExt {
    private static final String objectString = "Ljava/lang/Object;";
    private static final String serializableString = "Ljava/io/Serializable;";
    private static final String externalizableString = "Ljava/io/Externalizable;";
    private static final int objectLength = "Ljava/lang/Object;".length();
    private static final int serializableLength = "Ljava/io/Serializable;".length();
    private static final int externalizableLength = "Ljava/io/Externalizable;".length();
    private static final boolean debugIsAny = false;

    ObjectStreamClassCorbaExt() {
    }

    static final boolean isAbstractInterface(Class cl) {
        ClassInfoCache.ClassInfo cinfo = ClassInfoCache.get(cl);
        if (!cinfo.isInterface() || cinfo.isARemote(cl)) {
            return false;
        }
        Method[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] exceptions = methods[i].getExceptionTypes();
            boolean exceptionMatch = false;
            for (int j = 0; j < exceptions.length && !exceptionMatch; ++j) {
                if (RemoteException.class != exceptions[j] && Throwable.class != exceptions[j] && Exception.class != exceptions[j] && IOException.class != exceptions[j]) continue;
                exceptionMatch = true;
            }
            if (exceptionMatch) continue;
            return false;
        }
        return true;
    }

    static final boolean isAny(String typeString) {
        int length = typeString.length();
        if (length == objectLength) {
            if (typeString.charAt(length - 2) == 't') {
                return objectString.equals(typeString);
            }
            return false;
        }
        if (length == serializableLength) {
            if (typeString.charAt(length - 2) == 'e') {
                return serializableString.equals(typeString);
            }
            return false;
        }
        if (length == externalizableLength) {
            return externalizableString.equals(typeString);
        }
        return false;
    }

    private static final Method[] getDeclaredMethods(final Class clz) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clz.getDeclaredMethods();
            }
        });
    }
}

