#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-2m2E8jyenQOIRwtaVtLt3k
key:                  postgrest-10.0.0-2m2E8jyenQOIRwtaVtLt3k
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  d41e1e732191ced72cb91b432e9b48a7
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.2.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-2m2E8jyenQOIRwtaVtLt3k
depends:
    HTTP-4000.4.1-HSmeOaWxydf6TvW23yrUC9
    Ranged-sets-0.4.0-1g0RUSOHvYM6DGmllZcxk4
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
    auto-update-0.1.6-EoYtKXB7PFi6ODmyUNltFj base-4.16.4.0
    base64-bytestring-1.2.1.0-74HkITi20nv2BdJvE3AKcV
    bytestring-0.11.4.0 case-insensitive-1.2.1.0-C9u4G83SV6G4MBj88LrUbo
    cassava-0.5.3.2-4IeZhHac9nh8sMxy4aGJWW
    configurator-pg-0.2.9-BXLWl4h0uV65I6VNru7kTL containers-0.6.5.1
    contravariant-extras-0.3.5.4-KQODmY3btn6QQJWMypRoY
    cookie-0.4.6-ATAyIjNvKdDFVIoN0dB8l5 directory-1.3.6.2
    either-5.0.2-IsRu9KijQMsIAtixbpzC7M
    gitrev-1.3.1-9lQGgHpaqCODNpyMdeEqev
    hasql-1.5.0.4-LWaSG4BArLcJlYxtB6rrWP
    hasql-dynamic-statements-0.3.1.1-2LvOUnvuiYa8WrUxO7PjSr
    hasql-notifications-0.2.0.4-4FdZAi9sCmKC6S3KnaaInl
    hasql-pool-0.5.2.2-KABuM242KvrHaWYy2x6Tu1
    hasql-transaction-1.0.1.1-IY7jLjq4UGE91ccPEwVzq9
    heredoc-0.2.0.0-D3AW9S2AOKs91e3wqBbhAD
    http-types-0.12.4-G97153ZIeGq6X7uXEs2l2V
    insert-ordered-containers-0.2.5.3-4BUHeYZbmRNFUJRd5AGaG0
    interpolatedstring-perl6-1.0.2-5EYaYXW16kBGvkQpfr03gp
    jose-0.10-15O4sNjiZuRBhbBETmRtTH lens-5.2.3-44yRBOAfB7iFMS16KrPjpp
    lens-aeson-1.2.3-BBphJVjNPgEDcmhk2pQ1eR mtl-2.2.2
    network-3.1.4.0-I7hY9PROidqFfCvyq23hqh
    network-uri-2.6.4.2-EwAfSnfKix9WHRPnJWEEo
    optparse-applicative-0.17.1.0-AgMeQrX7nmlDOnX2xcegDb
    parsec-3.1.15.0 protolude-0.3.4-D1VQqEs8LBFpQdycuDixc
    regex-tdfa-1.3.2.2-9zKmqEaVx0vIf4YwE2VWyu
    retry-0.9.3.1-CrvRIAVIMpsFqTSjtzivOX
    scientific-0.3.7.0-7nXcZobZD337Jkf1NR7gHa
    swagger2-2.8.9-6ZHjOQZsHlpEuyAq9IY72n text-1.2.5.0 time-1.11.1.1
    unix-2.7.2.2 unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    vault-0.3.1.5-C5JFE1LgrDL7hxmTFx9yAO
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ
    wai-3.2.4-BNQtAxBTTmbBe7Crr2a2xg
    wai-cors-0.2.7-GSUk0zM1b7sFtug1c4yYgT
    wai-extra-3.1.15-9pU0z7iIsCu8vLAVmw1tBo
    wai-logger-2.5.0-6RWeXtjPEwwGBOBXcC2dpg
    warp-3.3.30-JQuxlSSi13uLhX74fYOoJn

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

