# _FlattenNextFirstPromise
<span class="source-link">[[Source]](src/promises/_test.md#L280)</span>

Callback functions called after fulfilled/reject is called on the 1st
promise in our `flatten_next` tests.

All of the `flatten_next` tests a 2nd promise chained so none of these
actions should ever call `complete` on the `TestHelper` as there's another
promise in the chain.


```pony
primitive val _FlattenNextFirstPromise
```

## Constructors

### create
<span class="source-link">[[Source]](src/promises/_test.md#L280)</span>


```pony
new val create()
: _FlattenNextFirstPromise val^
```

#### Returns

* [_FlattenNextFirstPromise](promises-_FlattenNextFirstPromise.md) val^

---

## Public Functions

### successful_fulfill
<span class="source-link">[[Source]](src/promises/_test.md#L289)</span>


```pony
fun box successful_fulfill(
  send_on: String val,
  h: TestHelper val,
  expected: String val,
  actual: String val)
: Promise[String val] tag
```
#### Parameters

*   send_on: [String](builtin-String.md) val
*   h: [TestHelper](ponytest-TestHelper.md) val
*   expected: [String](builtin-String.md) val
*   actual: [String](builtin-String.md) val

#### Returns

* [Promise](promises-Promise.md)\[[String](builtin-String.md) val\] tag

---

### fulfill_will_error
<span class="source-link">[[Source]](src/promises/_test.md#L299)</span>


```pony
fun box fulfill_will_error(
  h: TestHelper val,
  expected: String val,
  actual: String val)
: Promise[String val] tag ?
```
#### Parameters

*   h: [TestHelper](ponytest-TestHelper.md) val
*   expected: [String](builtin-String.md) val
*   actual: [String](builtin-String.md) val

#### Returns

* [Promise](promises-Promise.md)\[[String](builtin-String.md) val\] tag ?

---

### fail_if_fulfill_is_called
<span class="source-link">[[Source]](src/promises/_test.md#L307)</span>


```pony
fun box fail_if_fulfill_is_called(
  h: TestHelper val,
  s: String val)
: Promise[String val] tag
```
#### Parameters

*   h: [TestHelper](ponytest-TestHelper.md) val
*   s: [String](builtin-String.md) val

#### Returns

* [Promise](promises-Promise.md)\[[String](builtin-String.md) val\] tag

---

### reject_expected
<span class="source-link">[[Source]](src/promises/_test.md#L311)</span>


```pony
fun box reject_expected(
  h: TestHelper val,
  action: String val)
: Promise[String val] tag ?
```
#### Parameters

*   h: [TestHelper](ponytest-TestHelper.md) val
*   action: [String](builtin-String.md) val

#### Returns

* [Promise](promises-Promise.md)\[[String](builtin-String.md) val\] tag ?

---

### fail_if_reject_is_called
<span class="source-link">[[Source]](src/promises/_test.md#L315)</span>


```pony
fun box fail_if_reject_is_called(
  h: TestHelper val)
: Promise[String val] tag
```
#### Parameters

*   h: [TestHelper](ponytest-TestHelper.md) val

#### Returns

* [Promise](promises-Promise.md)\[[String](builtin-String.md) val\] tag

---

### eq
<span class="source-link">[[Source]](src/promises/_test.md#L289)</span>


```pony
fun box eq(
  that: _FlattenNextFirstPromise val)
: Bool val
```
#### Parameters

*   that: [_FlattenNextFirstPromise](promises-_FlattenNextFirstPromise.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/promises/_test.md#L289)</span>


```pony
fun box ne(
  that: _FlattenNextFirstPromise val)
: Bool val
```
#### Parameters

*   that: [_FlattenNextFirstPromise](promises-_FlattenNextFirstPromise.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

