# Signaled
<span class="source-link">[[Source]](src/process/_process.md#L119)</span>

Process exit status: Process was terminated by a signal.


```pony
class val Signaled is
  Stringable box,
  Equatable[(Exited val | Signaled val)] ref
```

#### Implements

* [Stringable](builtin-Stringable.md) box
* [Equatable](builtin-Equatable.md)\[([Exited](process-Exited.md) val | [Signaled](process-Signaled.md) val)\] ref

---

## Constructors

### create
<span class="source-link">[[Source]](src/process/_process.md#L125)</span>


```pony
new val create(
  sig: U32 val)
: Signaled val^
```
#### Parameters

*   sig: [U32](builtin-U32.md) val

#### Returns

* [Signaled](process-Signaled.md) val^

---

## Public Functions

### signal
<span class="source-link">[[Source]](src/process/_process.md#L128)</span>


Retrieve the signal number that exited the process.


```pony
fun box signal()
: U32 val
```

#### Returns

* [U32](builtin-U32.md) val

---

### string
<span class="source-link">[[Source]](src/process/_process.md#L134)</span>


```pony
fun box string()
: String iso^
```

#### Returns

* [String](builtin-String.md) iso^

---

### eq
<span class="source-link">[[Source]](src/process/_process.md#L142)</span>


```pony
fun box eq(
  other: (Exited val | Signaled val))
: Bool val
```
#### Parameters

*   other: ([Exited](process-Exited.md) val | [Signaled](process-Signaled.md) val)

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/builtin/compare.md#L20)</span>


```pony
fun box ne(
  that: (Exited val | Signaled val))
: Bool val
```
#### Parameters

*   that: ([Exited](process-Exited.md) val | [Signaled](process-Signaled.md) val)

#### Returns

* [Bool](builtin-Bool.md) val

---

