# Fibonacci\[optional A: ([Integer](builtin-Integer.md)\[A\] val & ([U8](builtin-U8.md) val | [U16](builtin-U16.md) val | [U32](builtin-U32.md) val | [U64](builtin-U64.md) val | [U128](builtin-U128.md) val | [ULong](builtin-ULong.md) val | [USize](builtin-USize.md) val))\]
<span class="source-link">[[Source]](src/math/fibonacci.md#L1)</span>

Useful for microbenchmarks to impress your friends. Look y'all, Pony goes
fast! We suppose if you are into Agile planning poker that you could also
use this in conjunction with `Random` to assign User Story Points.


```pony
class ref Fibonacci[optional A: (Integer[A] val & (U8 val | U16 val | U32 val | 
    U64 val | U128 val | ULong val | 
    USize val))] is
  Iterator[A] ref
```

#### Implements

* [Iterator](builtin-Iterator.md)\[A\] ref

---

## Constructors

### create
<span class="source-link">[[Source]](src/math/fibonacci.md#L1)</span>


```pony
new iso create()
: Fibonacci[A] iso^
```

#### Returns

* [Fibonacci](math-Fibonacci.md)\[A\] iso^

---

## Public Functions

### apply
<span class="source-link">[[Source]](src/math/fibonacci.md#L11)</span>


```pony
fun box apply(
  n: U8 val)
: A
```
#### Parameters

*   n: [U8](builtin-U8.md) val

#### Returns

* A

---

### has_next
<span class="source-link">[[Source]](src/math/fibonacci.md#L29)</span>


```pony
fun box has_next()
: Bool val
```

#### Returns

* [Bool](builtin-Bool.md) val

---

### next
<span class="source-link">[[Source]](src/math/fibonacci.md#L31)</span>


```pony
fun ref next()
: A
```

#### Returns

* A

---

