/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.stereo.Stereotag;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandCreatePackageState
extends SingleLineCommand2<StateDiagram> {
    public CommandCreatePackageState() {
        super(CommandCreatePackageState.getRegexConcat());
    }

    @Override
    public boolean isEligibleFor(ParserPass pass) {
        return pass == ParserPass.ONE || pass == ParserPass.TWO || pass == ParserPass.THREE;
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreatePackageState.class.getName(), RegexLeaf.start(), new RegexLeaf("state"), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexConcat(new RegexLeaf("CODE1", "([%pLN_.]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("DISPLAY1", "[%g]([^%g]+)[%g]")), new RegexConcat(new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("DISPLAY2", "[%g]([^%g]+)[%g]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore())), new RegexLeaf("CODE2", "([%pLN_.]+)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), StereotypePattern.optional("STEREOTYPE"), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), CommandCreatePackageState.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("LINECOLOR", "##(?:\\[(dotted|dashed|bold)\\])?(\\w+)?")), new RegexLeaf("(?:[%s]*\\{|[%s]+begin)"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    private String getNotNull(RegexResult arg, String v1, String v2) {
        if (arg.get(v1, 0) == null) {
            return arg.get(v2, 0);
        }
        return arg.get(v1, 0);
    }

    @Override
    protected CommandExecutionResult executeArg(StateDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        HColor lineColor;
        String urlString;
        String stereotype;
        String idShort = this.getNotNull(arg, "CODE1", "CODE2");
        Quark<Entity> quark = diagram.quarkInContext(true, idShort);
        String display = this.getNotNull(arg, "DISPLAY1", "DISPLAY2");
        diagram.gotoGroup(quark, Display.getWithNewlines(diagram.getPragma(), display == null ? quark.getName() : display), GroupType.STATE);
        Entity p = diagram.getCurrentGroup();
        if (display != null) {
            p.setDisplay(Display.getWithNewlines(diagram.getPragma(), display));
        }
        if ((stereotype = arg.get("STEREOTYPE", 0)) != null) {
            p.setStereotype(Stereotype.build(stereotype));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            p.addUrl(url);
        }
        Colors colors = CommandCreatePackageState.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        String s2 = arg.get("LINECOLOR", 1);
        HColor hColor = lineColor = s2 == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s2);
        if (lineColor != null) {
            colors = colors.add(ColorType.LINE, lineColor);
        }
        if (arg.get("LINECOLOR", 0) != null) {
            colors = colors.addLegacyStroke(arg.get("LINECOLOR", 0));
        }
        p.setColors(colors);
        CommandCreateClassMultilines.addTags(p, arg.getLazzy("TAGS", 0));
        return CommandExecutionResult.ok();
    }
}

