/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram;

import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.skin.UmlDiagramType;

public class DescriptionDiagram
extends AbstractEntityDiagram {
    public DescriptionDiagram(UmlSource source, Map<String, String> skinMap) {
        super(source, UmlDiagramType.DESCRIPTION, skinMap);
    }

    @Override
    public String cleanId(String id) {
        if (id == null) {
            return null;
        }
        if (id.startsWith("()")) {
            id = StringUtils.trin(id.substring(2));
        }
        if (id.startsWith(":") && id.endsWith(":/")) {
            return id.substring(1, id.length() - 2);
        }
        if (id.startsWith("(") && id.endsWith(")/")) {
            return id.substring(1, id.length() - 2);
        }
        return super.cleanId(id);
    }

    private boolean isUsecase() {
        for (Entity leaf : this.leafs()) {
            LeafType type = leaf.getLeafType();
            USymbol usymbol = leaf.getUSymbol();
            if (type != LeafType.USECASE && usymbol != this.getSkinParam().actorStyle().toUSymbol()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void makeDiagramReady() {
        super.makeDiagramReady();
        LeafType defaultType = LeafType.DESCRIPTION;
        USymbol defaultSymbol = this.isUsecase() ? this.getSkinParam().actorStyle().toUSymbol() : USymbols.INTERFACE;
        for (Entity leaf : this.leafs()) {
            if (leaf.getLeafType() != LeafType.STILL_UNKNOWN) continue;
            leaf.muteToType(defaultType, defaultSymbol);
        }
    }

    @Override
    public String checkFinalError() {
        if (!this.getPragma().useIntermediatePackages()) {
            this.packSomePackage();
        }
        this.applySingleStrategy();
        return super.checkFinalError();
    }
}

