/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.scheduler.parser;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;

public class IntervalScheduleParser {
    private static final Pattern DURATION_PATTERN = Pattern.compile("^(\\d+)\\s*(years?|months?|weeks?|days?|hours?|minutes?|minute|mins?|seconds?|secs?|milliseconds?|millis?|microseconds?|microsecond|micros?|micros|nanoseconds?|nanos?)$", 2);

    public static Schedule parse(Object schedule, Instant startTime) {
        if (schedule == null) {
            return null;
        }
        if (schedule instanceof Schedule) {
            return (Schedule)schedule;
        }
        if (!(schedule instanceof String)) {
            throw new IllegalArgumentException("Schedule must be a String object for parsing.");
        }
        String intervalStr = ((String)schedule).trim().toLowerCase();
        Matcher matcher = DURATION_PATTERN.matcher(intervalStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid interval format: " + intervalStr);
        }
        long value = Long.parseLong(matcher.group(1));
        String unitStr = matcher.group(2).toLowerCase();
        long intervalInMinutes = IntervalScheduleParser.convertToSupportedUnit(value, unitStr);
        return new IntervalSchedule(startTime, (int)intervalInMinutes, ChronoUnit.MINUTES);
    }

    @VisibleForTesting
    protected static long convertToSupportedUnit(long value, String unitStr) {
        switch (unitStr) {
            case "years": 
            case "year": {
                throw new IllegalArgumentException("Years cannot be converted to minutes accurately.");
            }
            case "months": 
            case "month": {
                throw new IllegalArgumentException("Months cannot be converted to minutes accurately.");
            }
            case "weeks": 
            case "week": {
                return value * 7L * 24L * 60L;
            }
            case "days": 
            case "day": {
                return value * 24L * 60L;
            }
            case "hours": 
            case "hour": {
                return value * 60L;
            }
            case "minutes": 
            case "minute": 
            case "mins": 
            case "min": {
                return value;
            }
            case "seconds": 
            case "second": 
            case "secs": 
            case "sec": {
                return value / 60L;
            }
            case "milliseconds": 
            case "millisecond": 
            case "millis": 
            case "milli": {
                return value / 60000L;
            }
            case "microseconds": 
            case "microsecond": 
            case "micros": 
            case "micro": {
                return value / 60000000L;
            }
            case "nanoseconds": 
            case "nanosecond": 
            case "nanos": 
            case "nano": {
                return value / 60000000000L;
            }
        }
        throw new IllegalArgumentException("Unsupported time unit: " + unitStr);
    }
}

