/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.xcontent;

import java.io.IOException;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.sql.spark.execution.session.SessionModel;
import org.opensearch.sql.spark.execution.session.SessionState;
import org.opensearch.sql.spark.execution.session.SessionType;
import org.opensearch.sql.spark.execution.xcontent.XContentSerializer;
import org.opensearch.sql.spark.execution.xcontent.XContentSerializerUtil;

public class SessionModelXContentSerializer
implements XContentSerializer<SessionModel> {
    public static final String SESSION_DOC_TYPE = "session";
    public static final String SESSION_TYPE = "sessionType";
    public static final String SESSION_ID = "sessionId";

    @Override
    public XContentBuilder toXContent(SessionModel sessionModel, ToXContent.Params params) throws IOException {
        return XContentFactory.jsonBuilder().startObject().field("version", sessionModel.getVersion()).field("type", SESSION_DOC_TYPE).field(SESSION_TYPE, sessionModel.getSessionType().getSessionType()).field(SESSION_ID, sessionModel.getSessionId()).field("state", sessionModel.getSessionState().getSessionState()).field("dataSourceName", sessionModel.getDatasourceName()).field("accountId", sessionModel.getAccountId()).field("applicationId", sessionModel.getApplicationId()).field("jobId", sessionModel.getJobId()).field("lastUpdateTime", sessionModel.getLastUpdateTime()).field("error", sessionModel.getError()).endObject();
    }

    @Override
    public SessionModel fromXContent(XContentParser parser, long seqNo, long primaryTerm) {
        SessionModel.SessionModelBuilder builder = SessionModel.builder();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "version": {
                    builder.version(parser.text());
                    break;
                }
                case "sessionType": {
                    builder.sessionType(SessionType.fromString((String)parser.text()));
                    break;
                }
                case "sessionId": {
                    builder.sessionId(parser.text());
                    break;
                }
                case "state": {
                    builder.sessionState(SessionState.fromString((String)parser.text()));
                    break;
                }
                case "dataSourceName": {
                    builder.datasourceName(parser.text());
                    break;
                }
                case "error": {
                    builder.error(parser.text());
                    break;
                }
                case "accountId": {
                    builder.accountId(parser.textOrNull());
                    break;
                }
                case "applicationId": {
                    builder.applicationId(parser.text());
                    break;
                }
                case "jobId": {
                    builder.jobId(parser.text());
                    break;
                }
                case "lastUpdateTime": {
                    builder.lastUpdateTime(parser.longValue());
                    break;
                }
            }
        }
        builder.metadata(XContentSerializerUtil.buildMetadata((long)seqNo, (long)primaryTerm));
        return builder.build();
    }
}

