/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.validator;

import lombok.Generated;
import org.opensearch.sql.spark.antlr.parser.SqlBaseParser;
import org.opensearch.sql.spark.antlr.parser.SqlBaseParserBaseVisitor;
import org.opensearch.sql.spark.validator.FunctionType;
import org.opensearch.sql.spark.validator.GrammarElement;
import org.opensearch.sql.spark.validator.GrammarElementValidator;

public class SQLQueryValidationVisitor
extends SqlBaseParserBaseVisitor<Void> {
    private final GrammarElementValidator grammarElementValidator;
    private static final String FILE_REFERENCE_PATTERN = "^[a-zA-Z]+\\.`[^`]+`$";

    @Override
    public Void visitCreateFunction(SqlBaseParser.CreateFunctionContext ctx) {
        this.validateAllowed(GrammarElement.CREATE_FUNCTION);
        return (Void)super.visitCreateFunction(ctx);
    }

    @Override
    public Void visitSetNamespaceProperties(SqlBaseParser.SetNamespacePropertiesContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        return (Void)super.visitSetNamespaceProperties(ctx);
    }

    @Override
    public Void visitAddTableColumns(SqlBaseParser.AddTableColumnsContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        return (Void)super.visitAddTableColumns(ctx);
    }

    @Override
    public Void visitAddTablePartition(SqlBaseParser.AddTablePartitionContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        return (Void)super.visitAddTablePartition(ctx);
    }

    @Override
    public Void visitRenameTableColumn(SqlBaseParser.RenameTableColumnContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        return (Void)super.visitRenameTableColumn(ctx);
    }

    @Override
    public Void visitDropTableColumns(SqlBaseParser.DropTableColumnsContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        return (Void)super.visitDropTableColumns(ctx);
    }

    @Override
    public Void visitAlterTableAlterColumn(SqlBaseParser.AlterTableAlterColumnContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        return (Void)super.visitAlterTableAlterColumn(ctx);
    }

    @Override
    public Void visitHiveReplaceColumns(SqlBaseParser.HiveReplaceColumnsContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        return (Void)super.visitHiveReplaceColumns(ctx);
    }

    @Override
    public Void visitSetTableSerDe(SqlBaseParser.SetTableSerDeContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        return (Void)super.visitSetTableSerDe(ctx);
    }

    @Override
    public Void visitRenameTablePartition(SqlBaseParser.RenameTablePartitionContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        return (Void)super.visitRenameTablePartition(ctx);
    }

    @Override
    public Void visitDropTablePartitions(SqlBaseParser.DropTablePartitionsContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        return (Void)super.visitDropTablePartitions(ctx);
    }

    @Override
    public Void visitSetTableLocation(SqlBaseParser.SetTableLocationContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        return (Void)super.visitSetTableLocation(ctx);
    }

    @Override
    public Void visitRecoverPartitions(SqlBaseParser.RecoverPartitionsContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        return (Void)super.visitRecoverPartitions(ctx);
    }

    @Override
    public Void visitSetNamespaceLocation(SqlBaseParser.SetNamespaceLocationContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        return (Void)super.visitSetNamespaceLocation(ctx);
    }

    @Override
    public Void visitAlterViewQuery(SqlBaseParser.AlterViewQueryContext ctx) {
        this.validateAllowed(GrammarElement.ALTER_VIEW);
        return (Void)super.visitAlterViewQuery(ctx);
    }

    @Override
    public Void visitRenameTable(SqlBaseParser.RenameTableContext ctx) {
        if (ctx.VIEW() != null) {
            this.validateAllowed(GrammarElement.ALTER_VIEW);
        } else {
            this.validateAllowed(GrammarElement.ALTER_NAMESPACE);
        }
        return (Void)super.visitRenameTable(ctx);
    }

    @Override
    public Void visitCreateNamespace(SqlBaseParser.CreateNamespaceContext ctx) {
        this.validateAllowed(GrammarElement.CREATE_NAMESPACE);
        return (Void)super.visitCreateNamespace(ctx);
    }

    @Override
    public Void visitCreateTable(SqlBaseParser.CreateTableContext ctx) {
        this.validateAllowed(GrammarElement.CREATE_NAMESPACE);
        return (Void)super.visitCreateTable(ctx);
    }

    @Override
    public Void visitCreateTableLike(SqlBaseParser.CreateTableLikeContext ctx) {
        this.validateAllowed(GrammarElement.CREATE_NAMESPACE);
        return (Void)super.visitCreateTableLike(ctx);
    }

    @Override
    public Void visitReplaceTable(SqlBaseParser.ReplaceTableContext ctx) {
        this.validateAllowed(GrammarElement.CREATE_NAMESPACE);
        return (Void)super.visitReplaceTable(ctx);
    }

    @Override
    public Void visitDropNamespace(SqlBaseParser.DropNamespaceContext ctx) {
        this.validateAllowed(GrammarElement.DROP_NAMESPACE);
        return (Void)super.visitDropNamespace(ctx);
    }

    @Override
    public Void visitDropTable(SqlBaseParser.DropTableContext ctx) {
        this.validateAllowed(GrammarElement.DROP_NAMESPACE);
        return (Void)super.visitDropTable(ctx);
    }

    @Override
    public Void visitCreateView(SqlBaseParser.CreateViewContext ctx) {
        this.validateAllowed(GrammarElement.CREATE_VIEW);
        return (Void)super.visitCreateView(ctx);
    }

    @Override
    public Void visitDropView(SqlBaseParser.DropViewContext ctx) {
        this.validateAllowed(GrammarElement.DROP_VIEW);
        return (Void)super.visitDropView(ctx);
    }

    @Override
    public Void visitDropFunction(SqlBaseParser.DropFunctionContext ctx) {
        this.validateAllowed(GrammarElement.DROP_FUNCTION);
        return (Void)super.visitDropFunction(ctx);
    }

    @Override
    public Void visitRepairTable(SqlBaseParser.RepairTableContext ctx) {
        this.validateAllowed(GrammarElement.REPAIR_TABLE);
        return (Void)super.visitRepairTable(ctx);
    }

    @Override
    public Void visitTruncateTable(SqlBaseParser.TruncateTableContext ctx) {
        this.validateAllowed(GrammarElement.TRUNCATE_TABLE);
        return (Void)super.visitTruncateTable(ctx);
    }

    @Override
    public Void visitInsertOverwriteTable(SqlBaseParser.InsertOverwriteTableContext ctx) {
        this.validateAllowed(GrammarElement.INSERT);
        return (Void)super.visitInsertOverwriteTable(ctx);
    }

    @Override
    public Void visitInsertIntoReplaceWhere(SqlBaseParser.InsertIntoReplaceWhereContext ctx) {
        this.validateAllowed(GrammarElement.INSERT);
        return (Void)super.visitInsertIntoReplaceWhere(ctx);
    }

    @Override
    public Void visitInsertIntoTable(SqlBaseParser.InsertIntoTableContext ctx) {
        this.validateAllowed(GrammarElement.INSERT);
        return (Void)super.visitInsertIntoTable(ctx);
    }

    @Override
    public Void visitInsertOverwriteDir(SqlBaseParser.InsertOverwriteDirContext ctx) {
        this.validateAllowed(GrammarElement.INSERT);
        return (Void)super.visitInsertOverwriteDir(ctx);
    }

    @Override
    public Void visitInsertOverwriteHiveDir(SqlBaseParser.InsertOverwriteHiveDirContext ctx) {
        this.validateAllowed(GrammarElement.INSERT);
        return (Void)super.visitInsertOverwriteHiveDir(ctx);
    }

    @Override
    public Void visitLoadData(SqlBaseParser.LoadDataContext ctx) {
        this.validateAllowed(GrammarElement.LOAD);
        return (Void)super.visitLoadData(ctx);
    }

    @Override
    public Void visitExplain(SqlBaseParser.ExplainContext ctx) {
        this.validateAllowed(GrammarElement.EXPLAIN);
        return (Void)super.visitExplain(ctx);
    }

    @Override
    public Void visitTableName(SqlBaseParser.TableNameContext ctx) {
        String reference = ctx.identifierReference().getText();
        if (this.isFileReference(reference)) {
            this.validateAllowed(GrammarElement.FILE);
        }
        return (Void)super.visitTableName(ctx);
    }

    private boolean isFileReference(String reference) {
        return reference.matches(FILE_REFERENCE_PATTERN);
    }

    @Override
    public Void visitCtes(SqlBaseParser.CtesContext ctx) {
        this.validateAllowed(GrammarElement.WITH);
        return (Void)super.visitCtes(ctx);
    }

    @Override
    public Void visitQueryOrganization(SqlBaseParser.QueryOrganizationContext ctx) {
        if (ctx.CLUSTER() != null) {
            this.validateAllowed(GrammarElement.CLUSTER_BY);
        } else if (ctx.DISTRIBUTE() != null) {
            this.validateAllowed(GrammarElement.DISTRIBUTE_BY);
        }
        return (Void)super.visitQueryOrganization(ctx);
    }

    @Override
    public Void visitHint(SqlBaseParser.HintContext ctx) {
        this.validateAllowed(GrammarElement.HINTS);
        return (Void)super.visitHint(ctx);
    }

    @Override
    public Void visitInlineTable(SqlBaseParser.InlineTableContext ctx) {
        this.validateAllowed(GrammarElement.INLINE_TABLE);
        return (Void)super.visitInlineTable(ctx);
    }

    @Override
    public Void visitJoinType(SqlBaseParser.JoinTypeContext ctx) {
        if (ctx.CROSS() != null) {
            this.validateAllowed(GrammarElement.CROSS_JOIN);
        } else if (ctx.LEFT() != null && ctx.SEMI() != null) {
            this.validateAllowed(GrammarElement.LEFT_SEMI_JOIN);
        } else if (ctx.ANTI() != null) {
            this.validateAllowed(GrammarElement.LEFT_ANTI_JOIN);
        } else if (ctx.LEFT() != null) {
            this.validateAllowed(GrammarElement.LEFT_OUTER_JOIN);
        } else if (ctx.RIGHT() != null) {
            this.validateAllowed(GrammarElement.RIGHT_OUTER_JOIN);
        } else if (ctx.FULL() != null) {
            this.validateAllowed(GrammarElement.FULL_OUTER_JOIN);
        } else {
            this.validateAllowed(GrammarElement.INNER_JOIN);
        }
        return (Void)super.visitJoinType(ctx);
    }

    @Override
    public Void visitSample(SqlBaseParser.SampleContext ctx) {
        this.validateAllowed(GrammarElement.TABLESAMPLE);
        return (Void)super.visitSample(ctx);
    }

    @Override
    public Void visitTableValuedFunction(SqlBaseParser.TableValuedFunctionContext ctx) {
        this.validateAllowed(GrammarElement.TABLE_VALUED_FUNCTION);
        return (Void)super.visitTableValuedFunction(ctx);
    }

    @Override
    public Void visitLateralView(SqlBaseParser.LateralViewContext ctx) {
        this.validateAllowed(GrammarElement.LATERAL_VIEW);
        return (Void)super.visitLateralView(ctx);
    }

    @Override
    public Void visitRelation(SqlBaseParser.RelationContext ctx) {
        if (ctx.LATERAL() != null) {
            this.validateAllowed(GrammarElement.LATERAL_SUBQUERY);
        }
        return (Void)super.visitRelation(ctx);
    }

    @Override
    public Void visitJoinRelation(SqlBaseParser.JoinRelationContext ctx) {
        if (ctx.LATERAL() != null) {
            this.validateAllowed(GrammarElement.LATERAL_SUBQUERY);
        }
        return (Void)super.visitJoinRelation(ctx);
    }

    @Override
    public Void visitTransformClause(SqlBaseParser.TransformClauseContext ctx) {
        if (ctx.TRANSFORM() != null) {
            this.validateAllowed(GrammarElement.TRANSFORM);
        }
        return (Void)super.visitTransformClause(ctx);
    }

    @Override
    public Void visitManageResource(SqlBaseParser.ManageResourceContext ctx) {
        this.validateAllowed(GrammarElement.MANAGE_RESOURCE);
        return (Void)super.visitManageResource(ctx);
    }

    @Override
    public Void visitAnalyze(SqlBaseParser.AnalyzeContext ctx) {
        this.validateAllowed(GrammarElement.ANALYZE_TABLE);
        return (Void)super.visitAnalyze(ctx);
    }

    @Override
    public Void visitAnalyzeTables(SqlBaseParser.AnalyzeTablesContext ctx) {
        this.validateAllowed(GrammarElement.ANALYZE_TABLE);
        return (Void)super.visitAnalyzeTables(ctx);
    }

    @Override
    public Void visitCacheTable(SqlBaseParser.CacheTableContext ctx) {
        this.validateAllowed(GrammarElement.CACHE_TABLE);
        return (Void)super.visitCacheTable(ctx);
    }

    @Override
    public Void visitClearCache(SqlBaseParser.ClearCacheContext ctx) {
        this.validateAllowed(GrammarElement.CLEAR_CACHE);
        return (Void)super.visitClearCache(ctx);
    }

    @Override
    public Void visitDescribeNamespace(SqlBaseParser.DescribeNamespaceContext ctx) {
        this.validateAllowed(GrammarElement.DESCRIBE_NAMESPACE);
        return (Void)super.visitDescribeNamespace(ctx);
    }

    @Override
    public Void visitDescribeFunction(SqlBaseParser.DescribeFunctionContext ctx) {
        this.validateAllowed(GrammarElement.DESCRIBE_FUNCTION);
        return (Void)super.visitDescribeFunction(ctx);
    }

    @Override
    public Void visitDescribeRelation(SqlBaseParser.DescribeRelationContext ctx) {
        this.validateAllowed(GrammarElement.DESCRIBE_TABLE);
        return (Void)super.visitDescribeRelation(ctx);
    }

    @Override
    public Void visitDescribeQuery(SqlBaseParser.DescribeQueryContext ctx) {
        this.validateAllowed(GrammarElement.DESCRIBE_QUERY);
        return (Void)super.visitDescribeQuery(ctx);
    }

    @Override
    public Void visitRefreshResource(SqlBaseParser.RefreshResourceContext ctx) {
        this.validateAllowed(GrammarElement.REFRESH_RESOURCE);
        return (Void)super.visitRefreshResource(ctx);
    }

    @Override
    public Void visitRefreshTable(SqlBaseParser.RefreshTableContext ctx) {
        this.validateAllowed(GrammarElement.REFRESH_TABLE);
        return (Void)super.visitRefreshTable(ctx);
    }

    @Override
    public Void visitRefreshFunction(SqlBaseParser.RefreshFunctionContext ctx) {
        this.validateAllowed(GrammarElement.REFRESH_FUNCTION);
        return (Void)super.visitRefreshFunction(ctx);
    }

    @Override
    public Void visitResetConfiguration(SqlBaseParser.ResetConfigurationContext ctx) {
        this.validateAllowed(GrammarElement.RESET);
        return (Void)super.visitResetConfiguration(ctx);
    }

    @Override
    public Void visitResetQuotedConfiguration(SqlBaseParser.ResetQuotedConfigurationContext ctx) {
        this.validateAllowed(GrammarElement.RESET);
        return (Void)super.visitResetQuotedConfiguration(ctx);
    }

    @Override
    public Void visitSetConfiguration(SqlBaseParser.SetConfigurationContext ctx) {
        this.validateAllowed(GrammarElement.SET);
        return (Void)super.visitSetConfiguration(ctx);
    }

    @Override
    public Void visitShowColumns(SqlBaseParser.ShowColumnsContext ctx) {
        this.validateAllowed(GrammarElement.SHOW_COLUMNS);
        return (Void)super.visitShowColumns(ctx);
    }

    @Override
    public Void visitShowCreateTable(SqlBaseParser.ShowCreateTableContext ctx) {
        this.validateAllowed(GrammarElement.SHOW_CREATE_TABLE);
        return (Void)super.visitShowCreateTable(ctx);
    }

    @Override
    public Void visitShowNamespaces(SqlBaseParser.ShowNamespacesContext ctx) {
        this.validateAllowed(GrammarElement.SHOW_NAMESPACES);
        return (Void)super.visitShowNamespaces(ctx);
    }

    @Override
    public Void visitShowFunctions(SqlBaseParser.ShowFunctionsContext ctx) {
        this.validateAllowed(GrammarElement.SHOW_FUNCTIONS);
        return (Void)super.visitShowFunctions(ctx);
    }

    @Override
    public Void visitShowPartitions(SqlBaseParser.ShowPartitionsContext ctx) {
        this.validateAllowed(GrammarElement.SHOW_PARTITIONS);
        return (Void)super.visitShowPartitions(ctx);
    }

    @Override
    public Void visitShowTableExtended(SqlBaseParser.ShowTableExtendedContext ctx) {
        this.validateAllowed(GrammarElement.SHOW_TABLE_EXTENDED);
        return (Void)super.visitShowTableExtended(ctx);
    }

    @Override
    public Void visitShowTables(SqlBaseParser.ShowTablesContext ctx) {
        this.validateAllowed(GrammarElement.SHOW_TABLES);
        return (Void)super.visitShowTables(ctx);
    }

    @Override
    public Void visitShowTblProperties(SqlBaseParser.ShowTblPropertiesContext ctx) {
        this.validateAllowed(GrammarElement.SHOW_TBLPROPERTIES);
        return (Void)super.visitShowTblProperties(ctx);
    }

    @Override
    public Void visitShowViews(SqlBaseParser.ShowViewsContext ctx) {
        this.validateAllowed(GrammarElement.SHOW_VIEWS);
        return (Void)super.visitShowViews(ctx);
    }

    @Override
    public Void visitUncacheTable(SqlBaseParser.UncacheTableContext ctx) {
        this.validateAllowed(GrammarElement.UNCACHE_TABLE);
        return (Void)super.visitUncacheTable(ctx);
    }

    @Override
    public Void visitFunctionName(SqlBaseParser.FunctionNameContext ctx) {
        this.validateFunctionAllowed(ctx.qualifiedName().getText());
        return (Void)super.visitFunctionName(ctx);
    }

    private void validateFunctionAllowed(String function) {
        FunctionType type = FunctionType.fromFunctionName(function.toLowerCase());
        switch (type) {
            case MAP: {
                this.validateAllowed(GrammarElement.MAP_FUNCTIONS);
                break;
            }
            case CSV: {
                this.validateAllowed(GrammarElement.CSV_FUNCTIONS);
                break;
            }
            case MISC: {
                this.validateAllowed(GrammarElement.MISC_FUNCTIONS);
                break;
            }
            case UDF: {
                this.validateAllowed(GrammarElement.UDF);
            }
        }
    }

    private void validateAllowed(GrammarElement element) {
        if (!this.grammarElementValidator.isValid(element)) {
            throw new IllegalArgumentException(element + " is not allowed.");
        }
    }

    @Generated
    public SQLQueryValidationVisitor(GrammarElementValidator grammarElementValidator) {
        this.grammarElementValidator = grammarElementValidator;
    }
}

