/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.join;

import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.sql.legacy.domain.Condition;
import org.opensearch.sql.legacy.domain.Select;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.esdomain.OpenSearchClient;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.executor.join.ElasticJoinExecutor;
import org.opensearch.sql.legacy.query.DefaultQueryAction;
import org.opensearch.sql.legacy.query.join.BackOffRetryStrategy;
import org.opensearch.sql.legacy.query.join.NestedLoopsElasticRequestBuilder;
import org.opensearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import org.opensearch.sql.legacy.query.maker.Maker;

public class NestedLoopsElasticExecutor
extends ElasticJoinExecutor {
    private static final Logger LOG = LogManager.getLogger();
    private final NestedLoopsElasticRequestBuilder nestedLoopsRequest;

    public NestedLoopsElasticExecutor(Client client, NestedLoopsElasticRequestBuilder nestedLoops) {
        super(client, nestedLoops);
        this.nestedLoopsRequest = nestedLoops;
    }

    @Override
    protected List<SearchHit> innerRun() throws SqlParseException {
        ArrayList<SearchHit> combinedResults = new ArrayList<SearchHit>();
        int totalLimit = this.nestedLoopsRequest.getTotalLimit();
        int multiSearchMaxSize = this.nestedLoopsRequest.getMultiSearchMaxSize();
        Select secondTableSelect = this.nestedLoopsRequest.getSecondTable().getOriginalSelect();
        Where originalSecondTableWhere = secondTableSelect.getWhere();
        this.orderConditions(this.nestedLoopsRequest.getFirstTable().getAlias(), this.nestedLoopsRequest.getSecondTable().getAlias());
        if (!BackOffRetryStrategy.isHealthy()) {
            throw new IllegalStateException("Memory circuit is broken");
        }
        FetchWithScrollResponse fetchWithScrollResponse = this.firstFetch(this.nestedLoopsRequest.getFirstTable());
        SearchResponse firstTableResponse = fetchWithScrollResponse.getResponse();
        boolean needScrollForFirstTable = fetchWithScrollResponse.isNeedScrollForFirstTable();
        int currentCombinedResults = 0;
        boolean finishedWithFirstTable = false;
        while (totalLimit > currentCombinedResults && !finishedWithFirstTable) {
            SearchHit[] hits = firstTableResponse.getHits().getHits();
            boolean finishedMultiSearches = hits.length == 0;
            int currentHitsIndex = 0;
            while (!finishedMultiSearches) {
                MultiSearchRequest multiSearchRequest = this.createMultiSearchRequest(multiSearchMaxSize, this.nestedLoopsRequest.getConnectedWhere(), hits, secondTableSelect, originalSecondTableWhere, currentHitsIndex);
                int multiSearchSize = multiSearchRequest.requests().size();
                if (!BackOffRetryStrategy.isHealthy()) {
                    throw new IllegalStateException("Memory circuit is broken");
                }
                currentCombinedResults = this.combineResultsFromMultiResponses(combinedResults, totalLimit, currentCombinedResults, hits, currentHitsIndex, multiSearchRequest);
                finishedMultiSearches = (currentHitsIndex += multiSearchSize) >= hits.length - 1 || currentCombinedResults >= totalLimit;
            }
            if (hits.length < 10000) {
                needScrollForFirstTable = false;
            }
            if (finishedWithFirstTable) continue;
            if (needScrollForFirstTable) {
                if (!BackOffRetryStrategy.isHealthy()) {
                    throw new IllegalStateException("Memory circuit is broken");
                }
                Integer hintLimit = this.nestedLoopsRequest.getFirstTable().getHintLimit();
                if (hintLimit != null && hintLimit < 10000) {
                    firstTableResponse = this.getResponseWithHits(this.nestedLoopsRequest.getFirstTable(), hintLimit, firstTableResponse);
                    continue;
                }
                firstTableResponse = this.getResponseWithHits(this.nestedLoopsRequest.getFirstTable(), 10000, firstTableResponse);
                continue;
            }
            finishedWithFirstTable = true;
        }
        return combinedResults;
    }

    private int combineResultsFromMultiResponses(List<SearchHit> combinedResults, int totalLimit, int currentCombinedResults, SearchHit[] hits, int currentIndex, MultiSearchRequest multiSearchRequest) {
        MultiSearchResponse.Item[] responses = new OpenSearchClient(this.client).multiSearch(multiSearchRequest);
        String t1Alias = this.nestedLoopsRequest.getFirstTable().getAlias();
        String t2Alias = this.nestedLoopsRequest.getSecondTable().getAlias();
        for (int j = 0; j < responses.length && currentCombinedResults < totalLimit; ++j) {
            SearchHit hitFromFirstTable = hits[currentIndex + j];
            this.onlyReturnedFields(hitFromFirstTable.getSourceAsMap(), this.nestedLoopsRequest.getFirstTable().getReturnedFields(), this.nestedLoopsRequest.getFirstTable().getOriginalSelect().isSelectAll());
            SearchResponse multiItemResponse = responses[j].getResponse();
            if (multiItemResponse == null) continue;
            this.updateMetaSearchResults(multiItemResponse);
            SearchHits responseForHit = multiItemResponse.getHits();
            if (responseForHit.getHits().length == 0 && this.nestedLoopsRequest.getJoinType() == SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN) {
                SearchHit unmachedResult = this.createUnmachedResult(this.nestedLoopsRequest.getSecondTable().getReturnedFields(), currentCombinedResults, t1Alias, t2Alias, hitFromFirstTable);
                combinedResults.add(unmachedResult);
                ++currentCombinedResults;
                continue;
            }
            for (SearchHit matchedHit : responseForHit.getHits()) {
                SearchHit searchHit = this.getMergedHit(currentCombinedResults, t1Alias, t2Alias, hitFromFirstTable, matchedHit);
                combinedResults.add(searchHit);
                if (++currentCombinedResults >= totalLimit) break;
            }
            if (currentCombinedResults >= totalLimit) break;
        }
        return currentCombinedResults;
    }

    private SearchHit getMergedHit(int currentCombinedResults, String t1Alias, String t2Alias, SearchHit hitFromFirstTable, SearchHit matchedHit) {
        this.onlyReturnedFields(matchedHit.getSourceAsMap(), this.nestedLoopsRequest.getSecondTable().getReturnedFields(), this.nestedLoopsRequest.getSecondTable().getOriginalSelect().isSelectAll());
        HashMap documentFields = new HashMap();
        HashMap metaFields = new HashMap();
        matchedHit.getFields().forEach((fieldName, docField) -> (MapperService.META_FIELDS_BEFORE_7DOT8.contains(fieldName) ? metaFields : documentFields).put(fieldName, docField));
        SearchHit searchHit = new SearchHit(currentCombinedResults, hitFromFirstTable.getId() + "|" + matchedHit.getId(), documentFields, metaFields);
        searchHit.sourceRef(hitFromFirstTable.getSourceRef());
        searchHit.getSourceAsMap().clear();
        searchHit.getSourceAsMap().putAll(hitFromFirstTable.getSourceAsMap());
        this.mergeSourceAndAddAliases(matchedHit.getSourceAsMap(), searchHit, t1Alias, t2Alias);
        return searchHit;
    }

    private MultiSearchRequest createMultiSearchRequest(int multiSearchMaxSize, Where connectedWhere, SearchHit[] hits, Select secondTableSelect, Where originalWhere, int currentIndex) throws SqlParseException {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        for (int i = currentIndex; i < currentIndex + multiSearchMaxSize && i < hits.length; ++i) {
            Map hitFromFirstTableAsMap = hits[i].getSourceAsMap();
            Where newWhere = Where.newInstance();
            if (originalWhere != null) {
                newWhere.addWhere(originalWhere);
            }
            if (connectedWhere != null) {
                Where connectedWhereCloned = null;
                try {
                    connectedWhereCloned = (Where)connectedWhere.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                this.updateValuesOnWhereConditions(hitFromFirstTableAsMap, connectedWhereCloned);
                newWhere.addWhere(connectedWhereCloned);
            }
            if (newWhere.getWheres().size() != 0) {
                secondTableSelect.setWhere(newWhere);
            }
            DefaultQueryAction action = new DefaultQueryAction(this.client, secondTableSelect);
            action.explain();
            SearchRequestBuilder secondTableRequest = action.getRequestBuilder();
            Integer secondTableHintLimit = this.nestedLoopsRequest.getSecondTable().getHintLimit();
            if (secondTableHintLimit != null && secondTableHintLimit <= 10000) {
                secondTableRequest.setSize(secondTableHintLimit.intValue());
            }
            multiSearchRequest.add(secondTableRequest);
        }
        return multiSearchRequest;
    }

    private void updateValuesOnWhereConditions(Map<String, Object> hit, Where where) {
        if (where instanceof Condition) {
            Condition c = (Condition)where;
            Object value = this.deepSearchInMap(hit, c.getValue().toString());
            if (value == null) {
                value = Maker.NONE;
            }
            c.setValue(value);
        }
        for (Where innerWhere : where.getWheres()) {
            this.updateValuesOnWhereConditions(hit, innerWhere);
        }
    }

    private FetchWithScrollResponse firstFetch(TableInJoinRequestBuilder tableRequest) {
        SearchResponse responseWithHits;
        Integer hintLimit = tableRequest.getHintLimit();
        boolean needScrollForFirstTable = false;
        if (hintLimit != null && hintLimit < 10000) {
            responseWithHits = (SearchResponse)tableRequest.getRequestBuilder().setSize(hintLimit.intValue()).get();
            needScrollForFirstTable = false;
        } else {
            responseWithHits = this.getResponseWithHits(tableRequest, 10000, null);
            if (responseWithHits.getHits().getTotalHits() != null && responseWithHits.getHits().getTotalHits().value < 10000L) {
                needScrollForFirstTable = true;
            }
        }
        this.updateMetaSearchResults(responseWithHits);
        return new FetchWithScrollResponse(responseWithHits, needScrollForFirstTable);
    }

    private void orderConditions(String t1Alias, String t2Alias) {
        this.orderConditionRecursive(t1Alias, t2Alias, this.nestedLoopsRequest.getConnectedWhere());
    }

    private void orderConditionRecursive(String t1Alias, String t2Alias, Where where) {
        if (where == null) {
            return;
        }
        if (where instanceof Condition) {
            Condition c = (Condition)where;
            if (this.shouldReverse(c, t1Alias, t2Alias).booleanValue()) {
                try {
                    this.reverseOrderOfCondition(c, t1Alias, t2Alias);
                    return;
                }
                catch (SqlParseException sqlParseException) {
                    // empty catch block
                }
            }
            if (!c.getName().startsWith(t2Alias + ".") || !c.getValue().toString().startsWith(t1Alias + ".")) {
                throw new RuntimeException("On NestedLoops currently only supported Ordered conditions (t2.field2 OPEAR t1.field1) , badCondition was:" + c);
            }
            c.setName(c.getName().replaceFirst(t2Alias + ".", ""));
            c.setValue(c.getValue().toString().replaceFirst(t1Alias + ".", ""));
            return;
        }
        for (Where innerWhere : where.getWheres()) {
            this.orderConditionRecursive(t1Alias, t2Alias, innerWhere);
        }
    }

    private Boolean shouldReverse(Condition cond, String t1Alias, String t2Alias) {
        return cond.getName().startsWith(t1Alias + ".") && cond.getValue().toString().startsWith(t2Alias + ".") && cond.getOPERATOR().isSimpleOperator() != false;
    }

    private void reverseOrderOfCondition(Condition cond, String t1Alias, String t2Alias) throws SqlParseException {
        cond.setOPERATOR(cond.getOPERATOR().simpleReverse());
        String name = cond.getName();
        cond.setName(cond.getValue().toString().replaceFirst(t2Alias + ".", ""));
        cond.setValue(name.replaceFirst(t1Alias + ".", ""));
    }

    private class FetchWithScrollResponse {
        private SearchResponse response;
        private boolean needScrollForFirstTable;

        private FetchWithScrollResponse(SearchResponse response, boolean needScrollForFirstTable) {
            this.response = response;
            this.needScrollForFirstTable = needScrollForFirstTable;
        }

        public SearchResponse getResponse() {
            return this.response;
        }

        public boolean isNeedScrollForFirstTable() {
            return this.needScrollForFirstTable;
        }
    }
}

