/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter;

import java.util.Map;
import lombok.Generated;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.script.FilterScript;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.sql.data.model.ExprBooleanValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.opensearch.storage.script.core.ExpressionScript;

class ExpressionFilterScript
extends FilterScript {
    private final ExpressionScript expressionScript;

    public ExpressionFilterScript(Expression expression, SearchLookup lookup, LeafReaderContext context, Map<String, Object> params) {
        super(params, lookup, context);
        this.expressionScript = new ExpressionScript(expression);
    }

    public boolean execute() {
        return this.expressionScript.execute(() -> ((ExpressionFilterScript)this).getDoc(), this::evaluateExpression).booleanValue();
    }

    private ExprValue evaluateExpression(Expression expression, Environment<Expression, ExprValue> valueEnv) {
        ExprValue result = expression.valueOf(valueEnv);
        if (result.isNull()) {
            return ExprBooleanValue.of((Boolean)false);
        }
        if (result.type() != ExprCoreType.BOOLEAN) {
            throw new IllegalStateException(String.format("Expression has wrong result type instead of boolean: expression [%s], result [%s]", expression, result));
        }
        return result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpressionFilterScript)) {
            return false;
        }
        ExpressionFilterScript other = (ExpressionFilterScript)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ExpressionScript this$expressionScript = this.expressionScript;
        ExpressionScript other$expressionScript = other.expressionScript;
        return !(this$expressionScript == null ? other$expressionScript != null : !((Object)this$expressionScript).equals(other$expressionScript));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExpressionFilterScript;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExpressionScript $expressionScript = this.expressionScript;
        result = result * 59 + ($expressionScript == null ? 43 : ((Object)$expressionScript).hashCode());
        return result;
    }
}

