/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.operator.arthmetic;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.model.ExprByteValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprFloatValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprShortValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionDSL;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionSignature;
import org.opensearch.sql.expression.function.SerializableFunction;

public final class MathematicalFunction {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(MathematicalFunction.abs());
        repository.register(MathematicalFunction.acos());
        repository.register(MathematicalFunction.asin());
        repository.register(MathematicalFunction.atan());
        repository.register(MathematicalFunction.atan2());
        repository.register(MathematicalFunction.cbrt());
        repository.register(MathematicalFunction.ceil());
        repository.register(MathematicalFunction.ceiling());
        repository.register(MathematicalFunction.conv());
        repository.register(MathematicalFunction.cos());
        repository.register(MathematicalFunction.cosh());
        repository.register(MathematicalFunction.cot());
        repository.register(MathematicalFunction.crc32());
        repository.register(MathematicalFunction.degrees());
        repository.register(MathematicalFunction.euler());
        repository.register(MathematicalFunction.exp());
        repository.register(MathematicalFunction.expm1());
        repository.register(MathematicalFunction.floor());
        repository.register(MathematicalFunction.ln());
        repository.register(MathematicalFunction.log());
        repository.register(MathematicalFunction.log10());
        repository.register(MathematicalFunction.log2());
        repository.register(MathematicalFunction.mod());
        repository.register(MathematicalFunction.pi());
        repository.register(MathematicalFunction.pow());
        repository.register(MathematicalFunction.power());
        repository.register(MathematicalFunction.radians());
        repository.register(MathematicalFunction.rand());
        repository.register(MathematicalFunction.rint());
        repository.register(MathematicalFunction.round());
        repository.register(MathematicalFunction.sign());
        repository.register(MathematicalFunction.signum());
        repository.register(MathematicalFunction.sin());
        repository.register(MathematicalFunction.sinh());
        repository.register(MathematicalFunction.sqrt());
        repository.register(MathematicalFunction.tan());
        repository.register(MathematicalFunction.truncate());
    }

    private static DefaultFunctionResolver baseMathFunction(FunctionName functionName, SerializableFunction<ExprValue, ExprValue> formula, ExprCoreType returnType) {
        return FunctionDSL.define(functionName, ExprCoreType.numberTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling(formula), returnType, type)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver abs() {
        return FunctionDSL.define(BuiltinFunctionName.ABS.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprByteValue(Math.abs(v.byteValue().byteValue()))), ExprCoreType.BYTE, ExprCoreType.BYTE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprShortValue(Math.abs(v.shortValue().shortValue()))), ExprCoreType.SHORT, ExprCoreType.SHORT), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprIntegerValue(Math.abs(v.integerValue()))), ExprCoreType.INTEGER, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprLongValue(Math.abs(v.longValue()))), ExprCoreType.LONG, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprFloatValue(Float.valueOf(Math.abs(v.floatValue().floatValue())))), ExprCoreType.FLOAT, ExprCoreType.FLOAT), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprDoubleValue(Math.abs(v.doubleValue()))), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver ceil() {
        return FunctionDSL.define(BuiltinFunctionName.CEIL.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprLongValue(Math.ceil(v.doubleValue()))), ExprCoreType.LONG, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver ceiling() {
        return FunctionDSL.define(BuiltinFunctionName.CEILING.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprLongValue(Math.ceil(v.doubleValue()))), ExprCoreType.LONG, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver conv() {
        return FunctionDSL.define(BuiltinFunctionName.CONV.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((x, a, b) -> new ExprStringValue(Integer.toString(Integer.parseInt(x.stringValue(), a.integerValue()), b.integerValue()))), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.INTEGER, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((x, a, b) -> new ExprStringValue(Integer.toString(Integer.parseInt(x.integerValue().toString(), a.integerValue()), b.integerValue()))), ExprCoreType.STRING, ExprCoreType.INTEGER, ExprCoreType.INTEGER, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver crc32() {
        return FunctionDSL.define(BuiltinFunctionName.CRC32.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> {
            CRC32 crc = new CRC32();
            crc.update(v.stringValue().getBytes());
            return new ExprLongValue(crc.getValue());
        }), ExprCoreType.LONG, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver euler() {
        return FunctionDSL.define(BuiltinFunctionName.E.getName(), FunctionDSL.impl(() -> new ExprDoubleValue(Math.E), ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver exp() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.EXP.getName(), v -> new ExprDoubleValue(Math.exp(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver expm1() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.EXPM1.getName(), v -> new ExprDoubleValue(Math.expm1(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver floor() {
        return FunctionDSL.define(BuiltinFunctionName.FLOOR.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprLongValue(Math.floor(v.doubleValue()))), ExprCoreType.LONG, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver ln() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.LN.getName(), v -> v.doubleValue() <= 0.0 ? ExprNullValue.of() : new ExprDoubleValue(Math.log(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver log() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ExprType type : ExprCoreType.numberTypes()) {
            builder.add(FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v.doubleValue() <= 0.0 ? ExprNullValue.of() : new ExprDoubleValue(Math.log(v.doubleValue()))), ExprCoreType.DOUBLE, type));
        }
        for (ExprType baseType : ExprCoreType.numberTypes()) {
            for (ExprType numberType : ExprCoreType.numberTypes()) {
                builder.add(FunctionDSL.impl(FunctionDSL.nullMissingHandling((b, x) -> b.doubleValue() <= 0.0 || x.doubleValue() <= 0.0 ? ExprNullValue.of() : new ExprDoubleValue(Math.log(x.doubleValue()) / Math.log(b.doubleValue()))), ExprCoreType.DOUBLE, baseType, numberType));
            }
        }
        return FunctionDSL.define(BuiltinFunctionName.LOG.getName(), (List<SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>>>)builder.build());
    }

    private static DefaultFunctionResolver log10() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.LOG10.getName(), v -> v.doubleValue() <= 0.0 ? ExprNullValue.of() : new ExprDoubleValue(Math.log10(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver log2() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.LOG2.getName(), v -> v.doubleValue() <= 0.0 ? ExprNullValue.of() : new ExprDoubleValue(Math.log(v.doubleValue()) / Math.log(2.0)), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver mod() {
        return FunctionDSL.define(BuiltinFunctionName.MOD.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.byteValue() == 0 ? ExprNullValue.of() : new ExprByteValue(v1.byteValue() % v2.byteValue())), ExprCoreType.BYTE, ExprCoreType.BYTE, ExprCoreType.BYTE), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.shortValue() == 0 ? ExprNullValue.of() : new ExprShortValue(v1.shortValue() % v2.shortValue())), ExprCoreType.SHORT, ExprCoreType.SHORT, ExprCoreType.SHORT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.shortValue() == 0 ? ExprNullValue.of() : new ExprIntegerValue(Math.floorMod(v1.integerValue(), (int)v2.integerValue()))), ExprCoreType.INTEGER, ExprCoreType.INTEGER, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.shortValue() == 0 ? ExprNullValue.of() : new ExprLongValue(Math.floorMod((long)v1.longValue(), v2.longValue()))), ExprCoreType.LONG, ExprCoreType.LONG, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.shortValue() == 0 ? ExprNullValue.of() : new ExprFloatValue(Float.valueOf(v1.floatValue().floatValue() % v2.floatValue().floatValue()))), ExprCoreType.FLOAT, ExprCoreType.FLOAT, ExprCoreType.FLOAT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.shortValue() == 0 ? ExprNullValue.of() : new ExprDoubleValue(v1.doubleValue() % v2.doubleValue())), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver pi() {
        return FunctionDSL.define(BuiltinFunctionName.PI.getName(), FunctionDSL.impl(() -> new ExprDoubleValue(Math.PI), ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver pow() {
        return FunctionDSL.define(BuiltinFunctionName.POW.getName(), MathematicalFunction.powerFunctionImpl());
    }

    private static DefaultFunctionResolver power() {
        return FunctionDSL.define(BuiltinFunctionName.POWER.getName(), MathematicalFunction.powerFunctionImpl());
    }

    private static List<SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>>> powerFunctionImpl() {
        return Arrays.asList(FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprDoubleValue(Math.pow(v1.shortValue().shortValue(), v2.shortValue().shortValue()))), ExprCoreType.DOUBLE, ExprCoreType.SHORT, ExprCoreType.SHORT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprDoubleValue(Math.pow(v1.integerValue().intValue(), v2.integerValue().intValue()))), ExprCoreType.DOUBLE, ExprCoreType.INTEGER, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprDoubleValue(Math.pow(v1.longValue().longValue(), v2.longValue().longValue()))), ExprCoreType.DOUBLE, ExprCoreType.LONG, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v1.floatValue().floatValue() <= 0.0f && (double)v2.floatValue().floatValue() != Math.floor(v2.floatValue().floatValue()) ? ExprNullValue.of() : new ExprDoubleValue(Math.pow(v1.floatValue().floatValue(), v2.floatValue().floatValue()))), ExprCoreType.DOUBLE, ExprCoreType.FLOAT, ExprCoreType.FLOAT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v1.doubleValue() <= 0.0 && v2.doubleValue() != Math.floor(v2.doubleValue()) ? ExprNullValue.of() : new ExprDoubleValue(Math.pow(v1.doubleValue(), v2.doubleValue()))), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver rand() {
        return FunctionDSL.define(BuiltinFunctionName.RAND.getName(), FunctionDSL.impl(() -> new ExprFloatValue(Float.valueOf(new Random().nextFloat())), ExprCoreType.FLOAT), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprFloatValue(Float.valueOf(new Random(v.integerValue().intValue()).nextFloat()))), ExprCoreType.FLOAT, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver rint() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.RINT.getName(), v -> new ExprDoubleValue(Math.rint(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver round() {
        return FunctionDSL.define(BuiltinFunctionName.ROUND.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprLongValue(Math.round(v.integerValue().intValue()))), ExprCoreType.LONG, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprLongValue(Math.round(v.longValue().longValue()))), ExprCoreType.LONG, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprDoubleValue(Math.round(v.floatValue().floatValue()))), ExprCoreType.DOUBLE, ExprCoreType.FLOAT), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprDoubleValue(new BigDecimal(v.doubleValue()).setScale(0, RoundingMode.HALF_UP).doubleValue())), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE), FunctionDSL.impl(FunctionDSL.nullMissingHandling((x, d) -> new ExprLongValue(new BigDecimal(x.integerValue()).setScale((int)d.integerValue(), RoundingMode.HALF_UP).longValue())), ExprCoreType.LONG, ExprCoreType.INTEGER, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((x, d) -> new ExprLongValue(new BigDecimal(x.longValue()).setScale((int)d.integerValue(), RoundingMode.HALF_UP).longValue())), ExprCoreType.LONG, ExprCoreType.LONG, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((x, d) -> new ExprDoubleValue(new BigDecimal(x.floatValue().floatValue()).setScale((int)d.integerValue(), RoundingMode.HALF_UP).doubleValue())), ExprCoreType.DOUBLE, ExprCoreType.FLOAT, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((x, d) -> new ExprDoubleValue(new BigDecimal(x.doubleValue()).setScale((int)d.integerValue(), RoundingMode.HALF_UP).doubleValue())), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver sign() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.SIGN.getName(), v -> new ExprIntegerValue(Math.signum(v.doubleValue())), ExprCoreType.INTEGER);
    }

    private static DefaultFunctionResolver signum() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.SIGNUM.getName(), v -> new ExprIntegerValue(Math.signum(v.doubleValue())), ExprCoreType.INTEGER);
    }

    private static DefaultFunctionResolver sinh() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.SINH.getName(), v -> new ExprDoubleValue(Math.sinh(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver sqrt() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.SQRT.getName(), v -> v.doubleValue() < 0.0 ? ExprNullValue.of() : new ExprDoubleValue(Math.sqrt(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver cbrt() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.CBRT.getName(), v -> new ExprDoubleValue(Math.cbrt(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver truncate() {
        return FunctionDSL.define(BuiltinFunctionName.TRUNCATE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((x, y) -> new ExprLongValue(BigDecimal.valueOf(x.integerValue().intValue()).setScale((int)y.integerValue(), RoundingMode.DOWN).longValue())), ExprCoreType.LONG, ExprCoreType.INTEGER, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((x, y) -> new ExprLongValue(BigDecimal.valueOf(x.longValue()).setScale((int)y.integerValue(), RoundingMode.DOWN).longValue())), ExprCoreType.LONG, ExprCoreType.LONG, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((x, y) -> new ExprDoubleValue(BigDecimal.valueOf(x.floatValue().floatValue()).setScale((int)y.integerValue(), RoundingMode.DOWN).doubleValue())), ExprCoreType.DOUBLE, ExprCoreType.FLOAT, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((x, y) -> new ExprDoubleValue(BigDecimal.valueOf(x.doubleValue()).setScale((int)y.integerValue(), RoundingMode.DOWN).doubleValue())), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver acos() {
        return FunctionDSL.define(BuiltinFunctionName.ACOS.getName(), ExprCoreType.numberTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v.doubleValue() < -1.0 || v.doubleValue() > 1.0 ? ExprNullValue.of() : new ExprDoubleValue(Math.acos(v.doubleValue()))), ExprCoreType.DOUBLE, type)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver asin() {
        return FunctionDSL.define(BuiltinFunctionName.ASIN.getName(), ExprCoreType.numberTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v.doubleValue() < -1.0 || v.doubleValue() > 1.0 ? ExprNullValue.of() : new ExprDoubleValue(Math.asin(v.doubleValue()))), ExprCoreType.DOUBLE, type)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver atan() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ExprType type : ExprCoreType.numberTypes()) {
            builder.add(FunctionDSL.impl(FunctionDSL.nullMissingHandling(x -> new ExprDoubleValue(Math.atan(x.doubleValue()))), type, ExprCoreType.DOUBLE));
            builder.add(FunctionDSL.impl(FunctionDSL.nullMissingHandling((y, x) -> new ExprDoubleValue(Math.atan2(y.doubleValue(), x.doubleValue()))), ExprCoreType.DOUBLE, type, type));
        }
        return FunctionDSL.define(BuiltinFunctionName.ATAN.getName(), (List<SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>>>)builder.build());
    }

    private static DefaultFunctionResolver atan2() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ExprType type : ExprCoreType.numberTypes()) {
            builder.add(FunctionDSL.impl(FunctionDSL.nullMissingHandling((y, x) -> new ExprDoubleValue(Math.atan2(y.doubleValue(), x.doubleValue()))), ExprCoreType.DOUBLE, type, type));
        }
        return FunctionDSL.define(BuiltinFunctionName.ATAN2.getName(), (List<SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>>>)builder.build());
    }

    private static DefaultFunctionResolver cos() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.COS.getName(), v -> new ExprDoubleValue(Math.cos(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver cosh() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.COSH.getName(), v -> new ExprDoubleValue(Math.cosh(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver cot() {
        return FunctionDSL.define(BuiltinFunctionName.COT.getName(), ExprCoreType.numberTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> {
            Double value = v.doubleValue();
            if (value == 0.0) {
                throw new ArithmeticException(String.format("Out of range value for cot(%s)", value));
            }
            return new ExprDoubleValue(1.0 / Math.tan(value));
        }), ExprCoreType.DOUBLE, type)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver degrees() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.DEGREES.getName(), v -> new ExprDoubleValue(Math.toDegrees(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver radians() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.RADIANS.getName(), v -> new ExprDoubleValue(Math.toRadians(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver sin() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.SIN.getName(), v -> new ExprDoubleValue(Math.sin(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    private static DefaultFunctionResolver tan() {
        return MathematicalFunction.baseMathFunction(BuiltinFunctionName.TAN.getName(), v -> new ExprDoubleValue(Math.tan(v.doubleValue())), ExprCoreType.DOUBLE);
    }

    @Generated
    private MathematicalFunction() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

