/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.storage.querybuilder;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.span.SpanExpression;

public class StepParameterResolver {
    public static String resolve(@NonNull Long startTime, @NonNull Long endTime, List<NamedExpression> groupByList) {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        Optional<SpanExpression> spanExpression = StepParameterResolver.getSpanExpression(groupByList);
        if (spanExpression.isPresent()) {
            if (StringUtils.isEmpty((CharSequence)spanExpression.get().getUnit().getName())) {
                throw new RuntimeException("Missing TimeUnit in the span expression");
            }
            return spanExpression.get().getValue().toString() + spanExpression.get().getUnit().getName();
        }
        return Math.max((endTime - startTime) / 250L, 1L) + "s";
    }

    private static Optional<SpanExpression> getSpanExpression(List<NamedExpression> namedExpressionList) {
        if (namedExpressionList == null) {
            return Optional.empty();
        }
        return namedExpressionList.stream().filter(expression -> expression.getDelegated() instanceof SpanExpression).map(expression -> (SpanExpression)expression.getDelegated()).findFirst();
    }

    @Generated
    public StepParameterResolver() {
    }
}

