/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.config;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslProvider;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.ssl.util.SSLConfigConstants;

public class SslParameters {
    private final SslProvider provider;
    private final ClientAuth clientAuth;
    private final List<String> protocols;
    private final List<String> ciphers;

    private SslParameters(SslProvider provider, ClientAuth clientAuth, List<String> protocols, List<String> ciphers) {
        this.provider = provider;
        this.ciphers = ciphers;
        this.protocols = protocols;
        this.clientAuth = clientAuth;
    }

    public ClientAuth clientAuth() {
        return this.clientAuth;
    }

    public SslProvider provider() {
        return this.provider;
    }

    public List<String> allowedCiphers() {
        return this.ciphers;
    }

    public List<String> allowedProtocols() {
        return this.protocols;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslParameters that = (SslParameters)o;
        return this.provider == that.provider && Objects.equals(this.ciphers, that.ciphers) && Objects.equals(this.protocols, that.protocols);
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.ciphers, this.protocols);
    }

    public static Loader loader(Settings sslConfigSettings) {
        return new Loader(sslConfigSettings);
    }

    public static final class Loader {
        private static final Logger LOGGER = LogManager.getLogger(SslParameters.class);
        private final Settings sslConfigSettings;

        public Loader(Settings sslConfigSettings) {
            this.sslConfigSettings = sslConfigSettings;
        }

        private SslProvider provider(Settings settings) {
            Boolean useOpenSslIfAvailable = settings.getAsBoolean("enable_openssl_if_available", Boolean.valueOf(true));
            if (SSLConfigConstants.OPENSSL_AVAILABLE && useOpenSslIfAvailable.booleanValue()) {
                return SslProvider.OPENSSL;
            }
            return SslProvider.JDK;
        }

        private List<String> protocols(SslProvider provider, Settings settings, boolean http) {
            List allowedProtocols = settings.getAsList("enabled_protocols", List.of(SSLConfigConstants.ALLOWED_SSL_PROTOCOLS));
            if (provider == SslProvider.OPENSSL) {
                String[] supportedProtocols = (long)OpenSsl.version() > SSLConfigConstants.OPENSSL_1_1_1_BETA_9 ? (http ? SSLConfigConstants.ALLOWED_OPENSSL_HTTP_PROTOCOLS : SSLConfigConstants.ALLOWED_OPENSSL_TRANSPORT_PROTOCOLS) : (http ? SSLConfigConstants.ALLOWED_OPENSSL_HTTP_PROTOCOLS_PRIOR_OPENSSL_1_1_1_BETA_9 : SSLConfigConstants.ALLOWED_OPENSSL_TRANSPORT_PROTOCOLS_PRIOR_OPENSSL_1_1_1_BETA_9);
                return this.openSslProtocols(allowedProtocols, supportedProtocols);
            }
            return this.jdkProtocols(allowedProtocols);
        }

        private List<String> openSslProtocols(List<String> allowedSslProtocols, String ... supportedProtocols) {
            LOGGER.debug("OpenSSL supports the following {} protocols {}", (Object)supportedProtocols.length, (Object)supportedProtocols);
            return Stream.of(supportedProtocols).filter(allowedSslProtocols::contains).collect(Collectors.toList());
        }

        private List<String> jdkProtocols(List<String> allowedSslProtocols) {
            try {
                String[] supportedProtocols = SSLContext.getDefault().getDefaultSSLParameters().getProtocols();
                LOGGER.debug("JVM supports the following {} protocols {}", (Object)supportedProtocols.length, (Object)supportedProtocols);
                return Stream.of(supportedProtocols).filter(allowedSslProtocols::contains).collect(Collectors.toList());
            }
            catch (NoSuchAlgorithmException e) {
                throw new OpenSearchException("Unable to determine supported protocols", (Throwable)e, new Object[0]);
            }
        }

        private List<String> ciphers(SslProvider provider, Settings settings) {
            Stream<String> allowedCiphers;
            List allowed = settings.getAsList("enabled_ciphers", List.of(SSLConfigConstants.ALLOWED_SSL_CIPHERS));
            if (provider == SslProvider.OPENSSL) {
                LOGGER.debug("OpenSSL {} supports the following ciphers (java-style) {}", (Object)OpenSsl.versionString(), (Object)OpenSsl.availableJavaCipherSuites());
                LOGGER.debug("OpenSSL {} supports the following ciphers (openssl-style) {}", (Object)OpenSsl.versionString(), (Object)OpenSsl.availableOpenSslCipherSuites());
                allowedCiphers = allowed.stream().filter(OpenSsl::isCipherSuiteAvailable);
            } else {
                try {
                    String[] supportedCiphers = SSLContext.getDefault().getDefaultSSLParameters().getCipherSuites();
                    LOGGER.debug("JVM supports the following {} ciphers {}", (Object)supportedCiphers.length, (Object)supportedCiphers);
                    allowedCiphers = Stream.of(supportedCiphers).filter(allowed::contains);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new OpenSearchException("Unable to determine ciphers protocols", (Throwable)e, new Object[0]);
                }
            }
            return allowedCiphers.sorted(String::compareTo).collect(Collectors.toList());
        }

        public SslParameters load(boolean http) {
            ClientAuth clientAuth = http ? ClientAuth.valueOf((String)this.sslConfigSettings.get("clientauth_mode", ClientAuth.OPTIONAL.name()).toUpperCase(Locale.ROOT)) : ClientAuth.REQUIRE;
            SslProvider provider = this.provider(this.sslConfigSettings);
            SslParameters sslParameters = new SslParameters(provider, clientAuth, this.protocols(provider, this.sslConfigSettings, http), this.ciphers(provider, this.sslConfigSettings));
            if (sslParameters.allowedProtocols().isEmpty()) {
                throw new OpenSearchSecurityException("No ssl protocols for " + (http ? "HTTP" : "Transport") + " layer", new Object[0]);
            }
            if (sslParameters.allowedCiphers().isEmpty()) {
                throw new OpenSearchSecurityException("No valid cipher suites for " + (http ? "HTTP" : "Transport") + " layer", new Object[0]);
            }
            return sslParameters;
        }
    }
}

