/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.config;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import org.opensearch.OpenSearchException;
import org.opensearch.common.collect.Tuple;
import org.opensearch.security.ssl.config.Certificate;
import org.opensearch.security.ssl.config.KeyStoreUtils;

public interface KeyStoreConfiguration {
    public List<Path> files();

    public List<Certificate> loadCertificates();

    default public KeyManagerFactory createKeyManagerFactory(boolean validateCertificates) {
        Tuple<KeyStore, char[]> keyStore = this.createKeyStore();
        if (validateCertificates) {
            KeyStoreUtils.validateKeyStoreCertificates((KeyStore)keyStore.v1());
        }
        return this.buildKeyManagerFactory((KeyStore)keyStore.v1(), (char[])keyStore.v2());
    }

    default public KeyManagerFactory buildKeyManagerFactory(KeyStore keyStore, char[] password) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password);
            return keyManagerFactory;
        }
        catch (GeneralSecurityException e) {
            throw new OpenSearchException("Failed to create KeyManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    public Tuple<KeyStore, char[]> createKeyStore();

    public static final class PemKeyStoreConfiguration
    implements KeyStoreConfiguration {
        private final Path certificateChainPath;
        private final Path keyPath;
        private final char[] keyPassword;

        public PemKeyStoreConfiguration(Path certificateChainPath, Path keyPath, char[] keyPassword) {
            this.certificateChainPath = certificateChainPath;
            this.keyPath = keyPath;
            this.keyPassword = keyPassword;
        }

        @Override
        public List<Certificate> loadCertificates() {
            X509Certificate[] certificates = KeyStoreUtils.x509Certificates(this.certificateChainPath);
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            listBuilder.add((Object)new Certificate(certificates[0], true));
            for (int i = 1; i < certificates.length; ++i) {
                listBuilder.add((Object)new Certificate(certificates[i], false));
            }
            return listBuilder.build();
        }

        @Override
        public List<Path> files() {
            return List.of(this.certificateChainPath, this.keyPath);
        }

        @Override
        public Tuple<KeyStore, char[]> createKeyStore() {
            KeyStore keyStore = KeyStoreUtils.newKeyStoreFromPem(this.certificateChainPath, this.keyPath, this.keyPassword);
            return Tuple.tuple((Object)keyStore, (Object)this.keyPassword);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PemKeyStoreConfiguration that = (PemKeyStoreConfiguration)o;
            return Objects.equals(this.certificateChainPath, that.certificateChainPath) && Objects.equals(this.keyPath, that.keyPath) && Objects.deepEquals(this.keyPassword, that.keyPassword);
        }

        public int hashCode() {
            return Objects.hash(this.certificateChainPath, this.keyPath, Arrays.hashCode(this.keyPassword));
        }
    }

    public static final class JdkKeyStoreConfiguration
    implements KeyStoreConfiguration {
        private final Path path;
        private final String type;
        private final String alias;
        private final char[] keyStorePassword;
        private final char[] keyPassword;

        public JdkKeyStoreConfiguration(Path path, String type, String alias, char[] keyStorePassword, char[] keyPassword) {
            this.path = path;
            this.type = type;
            this.alias = alias;
            this.keyStorePassword = keyStorePassword;
            this.keyPassword = keyPassword;
        }

        private void loadCertificateChain(String alias, KeyStore keyStore, ImmutableList.Builder<Certificate> listBuilder) throws KeyStoreException {
            java.security.cert.Certificate[] cc = keyStore.getCertificateChain(alias);
            boolean first = true;
            for (java.security.cert.Certificate c : cc) {
                if (!(c instanceof X509Certificate)) continue;
                listBuilder.add((Object)new Certificate((X509Certificate)c, this.type, alias, first));
                first = false;
            }
        }

        @Override
        public List<Certificate> loadCertificates() {
            KeyStore keyStore = KeyStoreUtils.loadKeyStore(this.path, this.type, this.keyStorePassword);
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            try {
                ImmutableList list;
                if (this.alias != null) {
                    if (keyStore.isKeyEntry(this.alias)) {
                        this.loadCertificateChain(this.alias, keyStore, (ImmutableList.Builder<Certificate>)listBuilder);
                    }
                } else {
                    for (String a : Collections.list(keyStore.aliases())) {
                        if (!keyStore.isKeyEntry(a)) continue;
                        this.loadCertificateChain(a, keyStore, (ImmutableList.Builder<Certificate>)listBuilder);
                    }
                }
                if ((list = listBuilder.build()).isEmpty()) {
                    throw new OpenSearchException("The file " + this.path + " does not contain any certificates", new Object[0]);
                }
                return listBuilder.build();
            }
            catch (GeneralSecurityException e) {
                throw new OpenSearchException("Couldn't load certificates from file " + this.path, (Throwable)e, new Object[0]);
            }
        }

        @Override
        public List<Path> files() {
            return List.of(this.path);
        }

        @Override
        public Tuple<KeyStore, char[]> createKeyStore() {
            KeyStore keyStore = KeyStoreUtils.newKeyStore(this.path, this.type, this.alias, this.keyStorePassword, this.keyPassword);
            return Tuple.tuple((Object)keyStore, (Object)this.keyPassword);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JdkKeyStoreConfiguration that = (JdkKeyStoreConfiguration)o;
            return Objects.equals(this.path, that.path) && Objects.equals(this.type, that.type) && Objects.equals(this.alias, that.alias) && Objects.deepEquals(this.keyStorePassword, that.keyStorePassword) && Objects.deepEquals(this.keyPassword, that.keyPassword);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.type, this.alias, Arrays.hashCode(this.keyStorePassword), Arrays.hashCode(this.keyPassword));
        }
    }
}

