/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl;

import io.netty.handler.ssl.SslContext;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.opensearch.security.ssl.SslConfiguration;
import org.opensearch.security.ssl.config.Certificate;
import org.opensearch.transport.NettyAllocator;

public class SslContextHandler {
    private SslContext sslContext;
    private final SslConfiguration sslConfiguration;
    private final List<Certificate> loadedCertificates;

    public SslContextHandler(SslConfiguration sslConfiguration) {
        this(sslConfiguration, false);
    }

    public SslContextHandler(SslConfiguration sslConfiguration, boolean client) {
        this.sslContext = client ? sslConfiguration.buildClientSslContext(true) : sslConfiguration.buildServerSslContext(true);
        this.sslConfiguration = sslConfiguration;
        this.loadedCertificates = sslConfiguration.certificates();
    }

    public SSLEngine createSSLEngine() {
        return this.sslContext.newEngine(NettyAllocator.getAllocator());
    }

    public SSLEngine createSSLEngine(String hostname, int port) {
        return this.sslContext.newEngine(NettyAllocator.getAllocator(), hostname, port);
    }

    public SslConfiguration sslConfiguration() {
        return this.sslConfiguration;
    }

    SslContext sslContext() {
        return this.sslContext;
    }

    public Stream<Certificate> keyMaterialCertificates() {
        return this.keyMaterialCertificates(this.loadedCertificates);
    }

    Stream<Certificate> keyMaterialCertificates(List<Certificate> certificates) {
        return certificates.stream().filter(Certificate::hasKey);
    }

    void reloadSslContext() throws CertificateException {
        List<Certificate> newCertificates = this.sslConfiguration.certificates();
        if (this.sameCertificates(newCertificates)) {
            return;
        }
        this.validateNewCertificates(newCertificates);
        this.invalidateSessions();
        this.sslContext = this.sslContext.isClient() ? this.sslConfiguration.buildClientSslContext(false) : this.sslConfiguration.buildServerSslContext(false);
        this.loadedCertificates.clear();
        this.loadedCertificates.addAll(newCertificates);
    }

    private boolean sameCertificates(List<Certificate> newCertificates) {
        Set currentCertSignatureSet = this.keyMaterialCertificates().map(Certificate::x509Certificate).map(X509Certificate::getSignature).map(s -> new String((byte[])s, StandardCharsets.UTF_8)).collect(Collectors.toSet());
        Set newCertSignatureSet = this.keyMaterialCertificates(newCertificates).map(Certificate::x509Certificate).map(X509Certificate::getSignature).map(s -> new String((byte[])s, StandardCharsets.UTF_8)).collect(Collectors.toSet());
        return currentCertSignatureSet.equals(newCertSignatureSet);
    }

    private void validateSubjectDns(List<Certificate> newCertificates) throws CertificateException {
        List newSubjectDNs;
        List currentSubjectDNs = this.keyMaterialCertificates().map(Certificate::subject).sorted().collect(Collectors.toList());
        if (!currentSubjectDNs.equals(newSubjectDNs = this.keyMaterialCertificates(newCertificates).map(Certificate::subject).sorted().collect(Collectors.toList()))) {
            throw new CertificateException("New certificates do not have valid Subject DNs. Current Subject DNs " + currentSubjectDNs + " new Subject DNs " + newSubjectDNs);
        }
    }

    private void validateIssuerDns(List<Certificate> newCertificates) throws CertificateException {
        List newIssuerDNs;
        List currentIssuerDNs = this.keyMaterialCertificates().map(Certificate::issuer).sorted().collect(Collectors.toList());
        if (!currentIssuerDNs.equals(newIssuerDNs = this.keyMaterialCertificates(newCertificates).map(Certificate::issuer).sorted().collect(Collectors.toList()))) {
            throw new CertificateException("New certificates do not have valid Issuer DNs. Current Issuer DNs: " + currentIssuerDNs + " new Issuer DNs: " + newIssuerDNs);
        }
    }

    private void validateSans(List<Certificate> newCertificates) throws CertificateException {
        List newSans;
        List currentSans = this.keyMaterialCertificates().map(Certificate::subjectAlternativeNames).sorted().collect(Collectors.toList());
        if (!currentSans.equals(newSans = this.keyMaterialCertificates(newCertificates).map(Certificate::subjectAlternativeNames).sorted().collect(Collectors.toList()))) {
            throw new CertificateException("New certificates do not have valid SANs. Current SANs: " + currentSans + " new SANs: " + newSans);
        }
    }

    private void validateNewCertificates(List<Certificate> newCertificates) throws CertificateException {
        for (Certificate certificate : newCertificates) {
            certificate.x509Certificate().checkValidity();
        }
        this.validateSubjectDns(newCertificates);
        this.validateIssuerDns(newCertificates);
        this.validateSans(newCertificates);
    }

    private void invalidateSessions() {
        SSLSessionContext sessionContext = this.sslContext.sessionContext();
        if (sessionContext != null) {
            for (byte[] sessionId : Collections.list(sessionContext.getIds())) {
                SSLSession session = sessionContext.getSession(sessionId);
                if (session == null) continue;
                session.invalidate();
            }
        }
    }
}

