/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.http;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.filter.SecurityResponse;
import org.opensearch.security.support.HTTPHelper;
import org.opensearch.security.user.AuthCredentials;

public class HTTPBasicAuthenticator
implements HTTPAuthenticator {
    protected final Logger log = LogManager.getLogger(this.getClass());

    public HTTPBasicAuthenticator(Settings settings, Path configPath) {
    }

    @Override
    public AuthCredentials extractCredentials(SecurityRequest request, ThreadContext threadContext) {
        boolean forceLogin = Boolean.getBoolean(request.params().get("force_login"));
        if (forceLogin) {
            return null;
        }
        String authorizationHeader = request.header("Authorization");
        return HTTPHelper.extractCredentials(authorizationHeader, this.log);
    }

    @Override
    public Optional<SecurityResponse> reRequestAuthentication(SecurityRequest request, AuthCredentials creds) {
        return Optional.of(new SecurityResponse(401, Map.of("WWW-Authenticate", "Basic realm=\"OpenSearch Security\""), "Unauthorized"));
    }

    @Override
    public String getType() {
        return "basic";
    }
}

