/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.NodesDn;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.threadpool.ThreadPool;

public class NodesDnApiAction
extends AbstractApiAction {
    public static final String STATIC_OPENSEARCH_YML_NODES_DN = "STATIC_OPENSEARCH_YML_NODES_DN";
    private final List<String> staticNodesDnFromEsYml;
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/nodesdn/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/nodesdn"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/nodesdn/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/nodesdn/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/nodesdn"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/nodesdn/{name}")));

    @Inject
    public NodesDnApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.NODESDN, clusterService, threadPool, securityApiDependencies);
        this.staticNodesDnFromEsYml = securityApiDependencies.settings().getAsList("plugins.security.nodes_dn", List.of());
        this.requestHandlersBuilder.configureRequestHandlers(this::nodesDnApiRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        if (this.securityApiDependencies.settings().getAsBoolean("plugins.security.nodes_dn_dynamic_config_enabled", Boolean.valueOf(false)).booleanValue()) {
            return routes;
        }
        return Collections.emptyList();
    }

    @Override
    protected CType<?> getConfigType() {
        return CType.NODESDN;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
        request.param("name");
        request.param("show_all");
    }

    private void nodesDnApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.verifyAccessForAllMethods().onGetRequest((CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)request -> this.processGetRequest((RestRequest)request).map(securityConfiguration -> {
            if (request.paramAsBoolean("show_all", false)) {
                SecurityDynamicConfiguration<?> configuration = securityConfiguration.configuration();
                this.addStaticNodesDn(configuration);
            }
            return ValidationResult.success(securityConfiguration);
        }))).onChangeRequest(RestRequest.Method.PATCH, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)this::processPatchRequest));
    }

    private void addStaticNodesDn(SecurityDynamicConfiguration<?> configuration) {
        if (!NodesDn.class.equals(configuration.getImplementingClass())) {
            throw new RuntimeException("Unknown class type - " + configuration.getImplementingClass());
        }
        NodesDn nodesDn = new NodesDn();
        nodesDn.setNodesDn(this.staticNodesDnFromEsYml);
        configuration.putCEntry(STATIC_OPENSEARCH_YML_NODES_DN, nodesDn);
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return NodesDnApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return NodesDnApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public ValidationResult<SecurityConfiguration> isAllowedToChangeImmutableEntity(SecurityConfiguration securityConfiguration) throws IOException {
                if (NodesDnApiAction.STATIC_OPENSEARCH_YML_NODES_DN.equals(securityConfiguration.entityName())) {
                    return ValidationResult.error(RestStatus.FORBIDDEN, Responses.forbiddenMessage("Resource 'STATIC_OPENSEARCH_YML_NODES_DN' is read-only."));
                }
                return EndpointValidator.super.isAllowedToChangeImmutableEntity(securityConfiguration);
            }

            @Override
            public RequestContentValidator createRequestContentValidator(final Object ... params) {
                return RequestContentValidator.of(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return params;
                    }

                    @Override
                    public Settings settings() {
                        return NodesDnApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Set<String> mandatoryKeys() {
                        return ImmutableSet.of((Object)"nodes_dn");
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        return ImmutableMap.of((Object)"nodes_dn", (Object)((Object)RequestContentValidator.DataType.ARRAY));
                    }
                });
            }
        };
    }
}

