/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;

public class ConfigurationMap {
    public static final ConfigurationMap EMPTY = new ConfigurationMap(ImmutableMap.of());
    private final ImmutableMap<CType<?>, SecurityDynamicConfiguration<?>> map;

    private ConfigurationMap(ImmutableMap<CType<?>, SecurityDynamicConfiguration<?>> map) {
        this.map = map;
    }

    public <T> SecurityDynamicConfiguration<T> get(CType<T> ctype) {
        SecurityDynamicConfiguration config = (SecurityDynamicConfiguration)this.map.get(ctype);
        if (config == null) {
            return null;
        }
        if (!config.getCType().equals(ctype)) {
            throw new RuntimeException("Stored configuration does not match type: " + ctype + "; " + config);
        }
        return config;
    }

    public boolean containsKey(CType<?> ctype) {
        return this.map.containsKey(ctype);
    }

    public Set<CType<?>> keySet() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public ImmutableMap<CType<?>, SecurityDynamicConfiguration<?>> rawMap() {
        return this.map;
    }

    public static ConfigurationMap of(SecurityDynamicConfiguration<?> ... configs) {
        Builder builder = new Builder();
        for (SecurityDynamicConfiguration<?> config : configs) {
            builder.with(config);
        }
        return builder.build();
    }

    public static class Builder {
        private Map<CType<?>, SecurityDynamicConfiguration<?>> map = new HashMap();

        public <T> Builder with(SecurityDynamicConfiguration<T> config) {
            this.map.put(config.getCType(), config);
            return this;
        }

        public Builder with(ConfigurationMap configurationMap) {
            this.map.putAll((Map<CType<?>, SecurityDynamicConfiguration<?>>)configurationMap.map);
            return this;
        }

        public <T> SecurityDynamicConfiguration<T> get(CType<T> ctype) {
            SecurityDynamicConfiguration<?> config = this.map.get(ctype);
            if (config == null) {
                return null;
            }
            if (!config.getCType().equals(ctype)) {
                throw new RuntimeException("Stored configuration does not match type: " + ctype + "; " + config);
            }
            return config;
        }

        public ConfigurationMap build() {
            return new ConfigurationMap(ImmutableMap.copyOf(this.map));
        }
    }
}

