/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.configuration.ConfigCallback;
import org.opensearch.security.configuration.ConfigurationMap;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.securityconf.Migration;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v6.RoleV6;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.securityconf.impl.v7.TenantV7;
import org.opensearch.security.support.ConfigHelper;
import org.opensearch.threadpool.ThreadPool;

public class ConfigurationLoaderSecurity7 {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final Client client;
    private final String securityIndex;
    private final ClusterService cs;
    private final Settings settings;
    private final AtomicBoolean isAuditConfigDocPresentInIndex = new AtomicBoolean();

    ConfigurationLoaderSecurity7(Client client, ThreadPool threadPool, Settings settings, ClusterService cs) {
        this.client = client;
        this.settings = settings;
        this.securityIndex = settings.get("plugins.security.config_index_name", ".opendistro_security");
        this.cs = cs;
        this.log.debug("Index is: {}", (Object)this.securityIndex);
    }

    boolean isAuditConfigDocPresentInIndex() {
        return this.isAuditConfigDocPresentInIndex.get();
    }

    ConfigurationMap load(final CType<?>[] events, long timeout, TimeUnit timeUnit, boolean acceptInvalid) throws InterruptedException, TimeoutException {
        final CountDownLatch latch = new CountDownLatch(events.length);
        final ConfigurationMap.Builder result = new ConfigurationMap.Builder();
        final boolean isDebugEnabled = this.log.isDebugEnabled();
        this.loadAsync(events, new ConfigCallback(){

            @Override
            public void success(SecurityDynamicConfiguration<?> dConf) {
                if (latch.getCount() <= 0L) {
                    ConfigurationLoaderSecurity7.this.log.error("Latch already counted down (for {} of {})  (index={})", (Object)dConf.getCType().toLCString(), (Object)Arrays.toString(events), (Object)ConfigurationLoaderSecurity7.this.securityIndex);
                }
                if (dConf.getCType() == CType.AUDIT) {
                    ConfigurationLoaderSecurity7.this.isAuditConfigDocPresentInIndex.set(true);
                }
                result.with(dConf);
                latch.countDown();
                if (isDebugEnabled) {
                    ConfigurationLoaderSecurity7.this.log.debug("Received config for {} (of {}) with current latch value={}", (Object)dConf.getCType().toLCString(), (Object)Arrays.toString(events), (Object)latch.getCount());
                }
            }

            @Override
            public void singleFailure(MultiGetResponse.Failure failure) {
                ConfigurationLoaderSecurity7.this.log.error("Failure {} retrieving configuration for {} (index={})", (Object)(failure == null ? null : failure.getMessage()), (Object)Arrays.toString(events), (Object)ConfigurationLoaderSecurity7.this.securityIndex);
            }

            @Override
            public void noData(String id) {
                CType<?> cType = CType.fromString(id);
                if (cType == CType.NODESDN || cType == CType.WHITELIST || cType == CType.ALLOWLIST || cType == CType.TENANTS) {
                    try {
                        SecurityDynamicConfiguration<?> empty = ConfigHelper.createEmptySdc(cType, ConfigurationRepository.getDefaultConfigVersion());
                        result.with(empty);
                        latch.countDown();
                        return;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (cType == CType.AUDIT) {
                    ConfigurationLoaderSecurity7.this.isAuditConfigDocPresentInIndex.set(false);
                    try {
                        SecurityDynamicConfiguration<?> empty = ConfigHelper.createEmptySdc(cType, ConfigurationRepository.getDefaultConfigVersion());
                        empty.putCObject("config", AuditConfig.from(ConfigurationLoaderSecurity7.this.settings));
                        result.with(empty);
                        latch.countDown();
                        return;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                ConfigurationLoaderSecurity7.this.log.warn("No data for {} while retrieving configuration for {}  (index={})", (Object)id, (Object)Arrays.toString(events), (Object)ConfigurationLoaderSecurity7.this.securityIndex);
            }

            @Override
            public void failure(Throwable t) {
                ConfigurationLoaderSecurity7.this.log.error("Exception while retrieving configuration for {} (index={})", (Object)Arrays.toString(events), (Object)ConfigurationLoaderSecurity7.this.securityIndex, (Object)t);
            }
        }, acceptInvalid);
        if (!latch.await(timeout, timeUnit)) {
            throw new TimeoutException("Timeout after " + timeout + timeUnit + " while retrieving configuration for " + Arrays.toString(events) + "(index=" + this.securityIndex + ")");
        }
        SecurityDynamicConfiguration<RoleV7> roleConfig = result.get(CType.ROLES);
        SecurityDynamicConfiguration<TenantV7> tenantConfig = result.get(CType.TENANTS);
        if (roleConfig != null && roleConfig.getAutoConvertedFrom() != null && (tenantConfig == null || tenantConfig.getCEntries().isEmpty())) {
            SecurityDynamicConfiguration<RoleV6> roleV6config = roleConfig.getAutoConvertedFrom();
            SecurityDynamicConfiguration<TenantV7> tenants = Migration.createTenants(roleV6config);
            result.with(tenants);
        }
        return result.build();
    }

    void loadAsync(CType<?>[] events, final ConfigCallback callback, final boolean acceptInvalid) {
        if (events == null || events.length == 0) {
            this.log.warn("No config events requested to load");
            return;
        }
        MultiGetRequest mget = new MultiGetRequest();
        for (int i = 0; i < events.length; ++i) {
            String event = events[i].toLCString();
            mget.add(this.securityIndex, event);
        }
        mget.refresh(true);
        mget.realtime(true);
        this.client.multiGet(mget, (ActionListener)new ActionListener<MultiGetResponse>(){

            public void onResponse(MultiGetResponse response) {
                MultiGetItemResponse[] responses = response.getResponses();
                for (int i = 0; i < responses.length; ++i) {
                    MultiGetItemResponse singleResponse = responses[i];
                    if (singleResponse != null && !singleResponse.isFailed()) {
                        GetResponse singleGetResponse = singleResponse.getResponse();
                        if (singleGetResponse.isExists() && !singleGetResponse.isSourceEmpty()) {
                            try {
                                SecurityDynamicConfiguration<?> dConf = ConfigurationLoaderSecurity7.this.toConfig(singleGetResponse, acceptInvalid);
                                if (dConf != null) {
                                    callback.success(dConf.deepClone());
                                    continue;
                                }
                                callback.failure(new Exception("Cannot parse settings for " + singleGetResponse.getId()));
                            }
                            catch (Exception e) {
                                ConfigurationLoaderSecurity7.this.log.error(e.toString());
                                callback.failure(e);
                            }
                            continue;
                        }
                        callback.noData(singleGetResponse.getId());
                        continue;
                    }
                    callback.singleFailure(singleResponse == null ? null : singleResponse.getFailure());
                }
            }

            public void onFailure(Exception e) {
                callback.failure(e);
            }
        });
    }

    /*
     * Exception decompiling
     */
    private SecurityDynamicConfiguration<?> toConfig(GetResponse singleGetResponse, boolean acceptInvalid) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

