/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Set;
import org.opensearch.SpecialPermission;
import org.opensearch.security.ConfigMapSerializer;

public class DefaultObjectMapper {
    public static final ObjectMapper objectMapper = new ObjectMapper();
    public static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final ObjectMapper defaulOmittingObjectMapper = new ObjectMapper();

    private DefaultObjectMapper() {
    }

    public static void inject(InjectableValues.Std injectableValues) {
        objectMapper.setInjectableValues((InjectableValues)injectableValues);
        YAML_MAPPER.setInjectableValues((InjectableValues)injectableValues);
        defaulOmittingObjectMapper.setInjectableValues((InjectableValues)injectableValues);
    }

    public static boolean getOrDefault(Map<String, Object> properties, String key, boolean defaultValue) throws JsonProcessingException {
        Object value = properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String text = ((String)value).trim();
            if ("true".equals(text) || "True".equals(text)) {
                return true;
            }
            if ("false".equals(text) || "False".equals(text)) {
                return false;
            }
            throw InvalidFormatException.from(null, (String)("Cannot deserialize value of type 'boolean' from String \"" + text + "\": only \"true\" or \"false\" recognized)"), null, Boolean.class);
        }
        throw MismatchedInputException.from(null, Boolean.class, (String)("Cannot deserialize instance of 'boolean' out of '" + value + "' (Property: " + key + ")"));
    }

    public static <T> T getOrDefault(Map<String, Object> properties, String key, T defaultValue) {
        Object value = properties.get(key);
        return (T)(value != null ? value : defaultValue);
    }

    public static <T> T readTree(JsonNode node, Class<T> clazz) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return (T)AccessController.doPrivileged(() -> objectMapper.treeToValue((TreeNode)node, clazz));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static <T> T readValue(String string, Class<T> clazz) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return (T)AccessController.doPrivileged(() -> objectMapper.readValue(string, clazz));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static JsonNode readTree(String string) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(() -> objectMapper.readTree(string));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static String writeValueAsString(Object value, boolean omitDefaults) throws JsonProcessingException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(() -> (omitDefaults ? defaulOmittingObjectMapper : objectMapper).writeValueAsString(value));
        }
        catch (PrivilegedActionException e) {
            throw (JsonProcessingException)e.getCause();
        }
    }

    public static String writeValueAsStringAndRedactSensitive(Object value) throws JsonProcessingException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new ConfigMapSerializer());
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
        try {
            return AccessController.doPrivileged(() -> mapper.writeValueAsString(value));
        }
        catch (PrivilegedActionException e) {
            throw (JsonProcessingException)e.getCause();
        }
    }

    public static <T> T readValue(final String string, final TypeReference<T> tr) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return objectMapper.readValue(string, tr);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static <T> T readValue(String string, JavaType jt) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return (T)AccessController.doPrivileged(() -> objectMapper.readValue(string, jt));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static <T> T convertValue(JsonNode jsonNode, JavaType jt) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return (T)AccessController.doPrivileged(() -> objectMapper.convertValue((Object)jsonNode, jt));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static TypeFactory getTypeFactory() {
        return objectMapper.getTypeFactory();
    }

    public static Set<String> getFields(Class<?> cls) {
        return (Set)objectMapper.getSerializationConfig().introspect(DefaultObjectMapper.getTypeFactory().constructType(cls)).findProperties().stream().map(BeanPropertyDefinition::getName).collect(ImmutableSet.toImmutableSet());
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(new JsonParser.Feature[]{JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION});
        defaulOmittingObjectMapper.disable(new JsonParser.Feature[]{JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION});
        YAML_MAPPER.disable(new JsonParser.Feature[]{JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION});
        objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
        defaulOmittingObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        defaulOmittingObjectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
        YAML_MAPPER.enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
    }
}

