/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.blobstore.BlobStore;
import software.amazon.awssdk.metrics.MetricCollection;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.MetricRecord;

public class StatsMetricPublisher {
    private static final Logger LOGGER = LogManager.getLogger(StatsMetricPublisher.class);
    private final Stats stats = new Stats();
    private final Map<BlobStore.Metric, Stats> extendedStats = new HashMap<BlobStore.Metric, Stats>(){
        {
            this.put(BlobStore.Metric.REQUEST_LATENCY, new Stats());
            this.put(BlobStore.Metric.REQUEST_SUCCESS, new Stats());
            this.put(BlobStore.Metric.REQUEST_FAILURE, new Stats());
            this.put(BlobStore.Metric.RETRY_COUNT, new Stats());
        }
    };
    public MetricPublisher listObjectsMetricPublisher = new MetricPublisher(){

        public void publish(MetricCollection metricCollection) {
            LOGGER.debug(() -> "List objects request metrics: " + metricCollection);
            for (MetricRecord metricRecord : metricCollection) {
                switch (metricRecord.metric().name()) {
                    case "ApiCallDuration": {
                        StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_LATENCY).listMetrics.addAndGet(((Duration)metricRecord.value()).toMillis());
                        break;
                    }
                    case "RetryCount": {
                        StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.RETRY_COUNT).listMetrics.addAndGet(((Integer)metricRecord.value()).intValue());
                        break;
                    }
                    case "ApiCallSuccessful": {
                        if (((Boolean)metricRecord.value()).booleanValue()) {
                            StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_SUCCESS).listMetrics.addAndGet(1L);
                        } else {
                            StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_FAILURE).listMetrics.addAndGet(1L);
                        }
                        StatsMetricPublisher.this.stats.listMetrics.addAndGet(1L);
                    }
                }
            }
        }

        public void close() {
        }
    };
    public MetricPublisher deleteObjectsMetricPublisher = new MetricPublisher(){

        public void publish(MetricCollection metricCollection) {
            LOGGER.debug(() -> "Delete objects request metrics: " + metricCollection);
            for (MetricRecord metricRecord : metricCollection) {
                switch (metricRecord.metric().name()) {
                    case "ApiCallDuration": {
                        StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_LATENCY).deleteMetrics.addAndGet(((Duration)metricRecord.value()).toMillis());
                        break;
                    }
                    case "RetryCount": {
                        StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.RETRY_COUNT).deleteMetrics.addAndGet(((Integer)metricRecord.value()).intValue());
                        break;
                    }
                    case "ApiCallSuccessful": {
                        if (((Boolean)metricRecord.value()).booleanValue()) {
                            StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_SUCCESS).deleteMetrics.addAndGet(1L);
                        } else {
                            StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_FAILURE).deleteMetrics.addAndGet(1L);
                        }
                        StatsMetricPublisher.this.stats.deleteMetrics.addAndGet(1L);
                    }
                }
            }
        }

        public void close() {
        }
    };
    public MetricPublisher getObjectMetricPublisher = new MetricPublisher(){

        public void publish(MetricCollection metricCollection) {
            LOGGER.debug(() -> "Get object request metrics: " + metricCollection);
            for (MetricRecord metricRecord : metricCollection) {
                switch (metricRecord.metric().name()) {
                    case "ApiCallDuration": {
                        StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_LATENCY).getMetrics.addAndGet(((Duration)metricRecord.value()).toMillis());
                        break;
                    }
                    case "RetryCount": {
                        StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.RETRY_COUNT).getMetrics.addAndGet(((Integer)metricRecord.value()).intValue());
                        break;
                    }
                    case "ApiCallSuccessful": {
                        if (((Boolean)metricRecord.value()).booleanValue()) {
                            StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_SUCCESS).getMetrics.addAndGet(1L);
                        } else {
                            StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_FAILURE).getMetrics.addAndGet(1L);
                        }
                        StatsMetricPublisher.this.stats.getMetrics.addAndGet(1L);
                    }
                }
            }
        }

        public void close() {
        }
    };
    public MetricPublisher putObjectMetricPublisher = new MetricPublisher(){

        public void publish(MetricCollection metricCollection) {
            LOGGER.debug(() -> "Put object request metrics: " + metricCollection);
            for (MetricRecord metricRecord : metricCollection) {
                switch (metricRecord.metric().name()) {
                    case "ApiCallDuration": {
                        StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_LATENCY).putMetrics.addAndGet(((Duration)metricRecord.value()).toMillis());
                        break;
                    }
                    case "RetryCount": {
                        StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.RETRY_COUNT).putMetrics.addAndGet(((Integer)metricRecord.value()).intValue());
                        break;
                    }
                    case "ApiCallSuccessful": {
                        if (((Boolean)metricRecord.value()).booleanValue()) {
                            StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_SUCCESS).putMetrics.addAndGet(1L);
                        } else {
                            StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_FAILURE).putMetrics.addAndGet(1L);
                        }
                        StatsMetricPublisher.this.stats.putMetrics.addAndGet(1L);
                    }
                }
            }
        }

        public void close() {
        }
    };
    public MetricPublisher multipartUploadMetricCollector = new MetricPublisher(){

        public void publish(MetricCollection metricCollection) {
            LOGGER.debug(() -> "Multi-part request metrics: " + metricCollection);
            for (MetricRecord metricRecord : metricCollection) {
                switch (metricRecord.metric().name()) {
                    case "ApiCallDuration": {
                        StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_LATENCY).multiPartPutMetrics.addAndGet(((Duration)metricRecord.value()).toMillis());
                        break;
                    }
                    case "RetryCount": {
                        StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.RETRY_COUNT).multiPartPutMetrics.addAndGet(((Integer)metricRecord.value()).intValue());
                        break;
                    }
                    case "ApiCallSuccessful": {
                        if (((Boolean)metricRecord.value()).booleanValue()) {
                            StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_SUCCESS).multiPartPutMetrics.addAndGet(1L);
                        } else {
                            StatsMetricPublisher.this.extendedStats.get((Object)BlobStore.Metric.REQUEST_FAILURE).multiPartPutMetrics.addAndGet(1L);
                        }
                        StatsMetricPublisher.this.stats.multiPartPutMetrics.addAndGet(1L);
                    }
                }
            }
        }

        public void close() {
        }
    };

    public MetricPublisher getDeleteObjectsMetricPublisher() {
        return this.deleteObjectsMetricPublisher;
    }

    public Stats getStats() {
        return this.stats;
    }

    public Map<BlobStore.Metric, Stats> getExtendedStats() {
        return this.extendedStats;
    }

    static class Stats {
        final AtomicLong listMetrics = new AtomicLong();
        final AtomicLong getMetrics = new AtomicLong();
        final AtomicLong putMetrics = new AtomicLong();
        final AtomicLong deleteMetrics = new AtomicLong();
        final AtomicLong multiPartPutMetrics = new AtomicLong();

        Stats() {
        }

        Map<String, Long> toMap() {
            HashMap<String, Long> results = new HashMap<String, Long>();
            results.put("GetObject", this.getMetrics.get());
            results.put("ListObjects", this.listMetrics.get());
            results.put("PutObject", this.putMetrics.get());
            results.put("DeleteObjects", this.deleteMetrics.get());
            results.put("PutMultipartObject", this.multiPartPutMetrics.get());
            return results;
        }
    }
}

