/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.neuralsearch.query.HybridQuery;

public final class HybridQueryBuilder
extends AbstractQueryBuilder<HybridQueryBuilder> {
    @Generated
    private static final Logger log = LogManager.getLogger(HybridQueryBuilder.class);
    public static final String NAME = "hybrid";
    private static final ParseField QUERIES_FIELD = new ParseField("queries", new String[0]);
    private final List<QueryBuilder> queries = new ArrayList<QueryBuilder>();
    private String fieldName;
    static final int MAX_NUMBER_OF_SUB_QUERIES = 5;

    public HybridQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.queries.addAll(this.readQueries(in));
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        this.writeQueries(out, this.queries);
    }

    public HybridQueryBuilder add(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "inner %s query clause cannot be null", NAME));
        }
        this.queries.add(queryBuilder);
        return this;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startArray(QUERIES_FIELD.getPreferredName());
        for (QueryBuilder queryBuilder : this.queries) {
            queryBuilder.toXContent(builder, params);
        }
        builder.endArray();
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    protected Query doToQuery(QueryShardContext queryShardContext) throws IOException {
        Collection<Query> queryCollection = this.toQueries(this.queries, queryShardContext);
        if (queryCollection.isEmpty()) {
            return Queries.newMatchNoDocsQuery((String)String.format(Locale.ROOT, "no clauses for %s query", NAME));
        }
        return new HybridQuery(queryCollection);
    }

    public static HybridQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        ArrayList<QueryBuilder> queries = new ArrayList<QueryBuilder>();
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERIES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queries.add(HybridQueryBuilder.parseInnerQueryBuilder((XContentParser)parser));
                    continue;
                }
                log.error(String.format(Locale.ROOT, "[%s] query does not support [%s]", NAME, currentFieldName));
                throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Field is not supported by [%s] query", NAME), new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (QUERIES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while (token != XContentParser.Token.END_ARRAY) {
                        if (queries.size() == 5) {
                            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Number of sub-queries exceeds maximum supported by [%s] query", NAME), new Object[0]);
                        }
                        queries.add(HybridQueryBuilder.parseInnerQueryBuilder((XContentParser)parser));
                        token = parser.nextToken();
                    }
                    continue;
                }
                log.error(String.format(Locale.ROOT, "[%s] query does not support [%s]", NAME, currentFieldName));
                throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Field is not supported by [%s] query", NAME), new Object[0]);
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                if (boost == 1.0f) continue;
                log.error("[{}] query does not support provided value {} for [{}]", (Object)NAME, (Object)Float.valueOf(boost), (Object)BOOST_FIELD);
                throw new ParsingException(parser.getTokenLocation(), "[{}] query does not support [{}]", new Object[]{NAME, BOOST_FIELD});
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            log.error(String.format(Locale.ROOT, "[%s] query does not support [%s]", NAME, currentFieldName));
            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Field is not supported by [%s] query", NAME), new Object[0]);
        }
        if (queries.isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "[%s] requires 'queries' field with at least one clause", NAME), new Object[0]);
        }
        HybridQueryBuilder compoundQueryBuilder = new HybridQueryBuilder();
        compoundQueryBuilder.queryName(queryName);
        compoundQueryBuilder.boost(boost);
        for (QueryBuilder query : queries) {
            compoundQueryBuilder.add(query);
        }
        return compoundQueryBuilder;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        HybridQueryBuilder newBuilder = new HybridQueryBuilder();
        boolean changed = false;
        for (QueryBuilder query : this.queries) {
            QueryBuilder result = query.rewrite(queryShardContext);
            if (result != query) {
                changed = true;
            }
            newBuilder.add(result);
        }
        if (changed) {
            newBuilder.queryName(this.queryName);
            newBuilder.boost(this.boost);
            return newBuilder;
        }
        return this;
    }

    protected boolean doEquals(HybridQueryBuilder obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.fieldName, (Object)obj.fieldName);
        equalsBuilder.append(this.queries, obj.queries);
        return equalsBuilder.isEquals();
    }

    protected int doHashCode() {
        return Objects.hash(this.queries);
    }

    public String getWriteableName() {
        return NAME;
    }

    private List<QueryBuilder> readQueries(StreamInput in) throws IOException {
        return in.readNamedWriteableList(QueryBuilder.class);
    }

    private void writeQueries(StreamOutput out, List<? extends QueryBuilder> queries) throws IOException {
        out.writeNamedWriteableList(queries);
    }

    private Collection<Query> toQueries(Collection<QueryBuilder> queryBuilders, QueryShardContext context) throws QueryShardException {
        List<Query> queries = queryBuilders.stream().map(qb -> {
            try {
                return qb.rewrite((QueryRewriteContext)context).toQuery(context);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return queries;
    }

    public void visit(QueryBuilderVisitor visitor) {
        visitor.accept((QueryBuilder)this);
        QueryBuilderVisitor subVisitor = visitor.getChildVisitor(BooleanClause.Occur.MUST);
        for (QueryBuilder subQueryBuilder : this.queries) {
            subQueryBuilder.visit(subVisitor);
        }
    }

    @Generated
    public List<QueryBuilder> queries() {
        return this.queries;
    }

    @Generated
    public String fieldName() {
        return this.fieldName;
    }

    @Generated
    public HybridQueryBuilder fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @Generated
    public HybridQueryBuilder() {
    }
}

