/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.util;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.opensearch.common.collect.Tuple;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.SearchHit;

public class ProcessorUtils {
    public static boolean validateRerankCriteria(SearchHit[] searchHits, SearchHitValidator validator, ActionListener<List<Float>> listener) {
        for (SearchHit hit : searchHits) {
            try {
                validator.validate(hit);
            }
            catch (IllegalArgumentException e) {
                listener.onFailure((Exception)e);
                return false;
            }
        }
        return true;
    }

    public static float getScoreFromSourceMap(Map<String, Object> sourceAsMap, String targetField) {
        Object val = ProcessorUtils.getValueFromSource(sourceAsMap, targetField).get();
        return ((Number)val).floatValue();
    }

    public static void removeTargetFieldFromSource(Map<String, Object> sourceAsMap, String targetField) {
        Stack<Tuple> parentMapChildrenKeyTupleStack = new Stack<Tuple>();
        String[] keys = targetField.split("\\.");
        Map currentMap = sourceAsMap;
        String lastKey = keys[keys.length - 1];
        for (String key : keys) {
            parentMapChildrenKeyTupleStack.add(new Tuple(currentMap, (Object)key));
            if (key.equals(lastKey)) break;
            currentMap = (Map)currentMap.get(key);
        }
        Tuple currentParentMapWithChild = (Tuple)parentMapChildrenKeyTupleStack.pop();
        Map parentMap = (Map)currentParentMapWithChild.v1();
        String key = (String)currentParentMapWithChild.v2();
        parentMap.remove(key);
        while (!parentMapChildrenKeyTupleStack.isEmpty()) {
            currentParentMapWithChild = (Tuple)parentMapChildrenKeyTupleStack.pop();
            parentMap = (Map)currentParentMapWithChild.v1();
            Map innerMap = (Map)parentMap.get(key = (String)currentParentMapWithChild.v2());
            if (innerMap == null || !innerMap.isEmpty()) continue;
            parentMap.remove(key);
        }
    }

    public static Optional<Object> getValueFromSource(Map<String, Object> sourceAsMap, String targetField) {
        String[] keys = targetField.split("\\.");
        Optional<Object> currentValue = Optional.of(sourceAsMap);
        for (String key : keys) {
            if (!(currentValue = currentValue.flatMap(value -> {
                if (!(value instanceof Map)) {
                    return Optional.empty();
                }
                Map currentMap = (Map)value;
                return Optional.ofNullable(currentMap.get(key));
            })).isEmpty()) continue;
            return Optional.empty();
        }
        return currentValue;
    }

    public static boolean mappingExistsInSource(Map<String, Object> sourceAsMap, String pathToValue) {
        return ProcessorUtils.getValueFromSource(sourceAsMap, pathToValue).isPresent();
    }

    @FunctionalInterface
    public static interface SearchHitValidator {
        public void validate(SearchHit var1) throws IllegalArgumentException;
    }
}

