/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StringUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(StringUtils.class);
    public static final String DEFAULT_ESCAPE_FUNCTION = "\n    String escape(def input) { \n      if (input.contains(\"\\\\\")) {\n        input = input.replace(\"\\\\\", \"\\\\\\\\\");\n      }\n      if (input.contains(\"\\\"\")) {\n        input = input.replace(\"\\\"\", \"\\\\\\\"\");\n      }\n      if (input.contains('\r')) {\n        input = input = input.replace('\r', '\\\\r');\n      }\n      if (input.contains(\"\\\\t\")) {\n        input = input.replace(\"\\\\t\", \"\\\\\\\\\\\\t\");\n      }\n      if (input.contains('\n')) {\n        input = input.replace('\n', '\\\\n');\n      }\n      if (input.contains('\b')) {\n        input = input.replace('\b', '\\\\b');\n      }\n      if (input.contains('\f')) {\n        input = input.replace('\f', '\\\\f');\n      }\n      return input;\n    }\n";
    public static final Gson gson = new Gson();
    public static final String TO_STRING_FUNCTION_NAME = ".toString()";

    public static boolean isValidJsonString(String Json) {
        try {
            new JSONObject(Json);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(Json);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public static boolean isJson(String json) {
        try {
            if (!StringUtils.isValidJsonString(json)) {
                return false;
            }
            gson.fromJson(json, Object.class);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }

    public static String toUTF8(String rawString) {
        ByteBuffer buffer = StandardCharsets.UTF_8.encode(rawString);
        String utf8EncodedString = StandardCharsets.UTF_8.decode(buffer).toString();
        return utf8EncodedString;
    }

    public static Map<String, Object> fromJson(String jsonStr, String defaultKey) {
        HashMap<String, List> result;
        JsonElement jsonElement = JsonParser.parseString((String)jsonStr);
        if (jsonElement.isJsonObject()) {
            result = (HashMap<String, List>)gson.fromJson(jsonElement, Map.class);
        } else if (jsonElement.isJsonArray()) {
            List list = (List)gson.fromJson(jsonElement, List.class);
            result = new HashMap<String, List>();
            result.put(defaultKey, list);
        } else {
            throw new IllegalArgumentException("Unsupported response type");
        }
        return result;
    }

    public static Map<String, String> filteredParameterMap(Map<String, ?> parameterObjs, Set<String> allowedList) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        HashSet<String> filteredKeys = new HashSet<String>(parameterObjs.keySet());
        filteredKeys.retainAll(allowedList);
        for (String key : filteredKeys) {
            Object value = parameterObjs.get(key);
            try {
                AccessController.doPrivileged(() -> {
                    if (value instanceof String) {
                        parameters.put(key, (String)value);
                    } else {
                        parameters.put(key, gson.toJson(value));
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }
        return parameters;
    }

    public static Map<String, String> getParameterMap(Map<String, ?> parameterObjs) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String key : parameterObjs.keySet()) {
            Object value = parameterObjs.get(key);
            try {
                AccessController.doPrivileged(() -> {
                    if (value instanceof String) {
                        parameters.put(key, (String)value);
                    } else {
                        parameters.put(key, gson.toJson(value));
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }
        return parameters;
    }

    public static String toJson(Object value) {
        try {
            return AccessController.doPrivileged(() -> {
                if (value instanceof String) {
                    return (String)value;
                }
                return gson.toJson(value);
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> convertScriptStringToJsonString(Map<String, Object> processedInput) {
        HashMap<String, String> parameterStringMap = new HashMap<String, String>();
        try {
            AccessController.doPrivileged(() -> {
                Map parametersMap = processedInput.getOrDefault("parameters", Map.of());
                for (String key : parametersMap.keySet()) {
                    if (parametersMap.get(key) instanceof String) {
                        parameterStringMap.put(key, (String)parametersMap.get(key));
                        continue;
                    }
                    parameterStringMap.put(key, gson.toJson(parametersMap.get(key)));
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            log.error("Error processing parameters", (Throwable)e);
            throw new RuntimeException(e);
        }
        return parameterStringMap;
    }

    public static List<String> processTextDocs(List<String> inputDocs) {
        ArrayList<String> docs = new ArrayList<String>();
        for (String doc : inputDocs) {
            docs.add(StringUtils.processTextDoc(doc));
        }
        return docs;
    }

    public static String processTextDoc(String doc) {
        if (doc != null) {
            String gsonString = gson.toJson((Object)doc);
            return gsonString.substring(1, gsonString.length() - 1);
        }
        return null;
    }

    public static String addDefaultMethod(String functionScript) {
        if (!StringUtils.containsEscapeMethod(functionScript) && StringUtils.isEscapeUsed(functionScript)) {
            return DEFAULT_ESCAPE_FUNCTION + functionScript;
        }
        return functionScript;
    }

    public static boolean patternExist(String input, String patternString) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(input);
        return matcher.find();
    }

    public static boolean isEscapeUsed(String input) {
        return StringUtils.patternExist(input, "(?<!\\bString\\s+)\\bescape\\s*\\(");
    }

    public static boolean containsEscapeMethod(String input) {
        return StringUtils.patternExist(input, "String\\s+escape\\s*\\(\\s*(def|String)\\s+.*?\\)\\s*\\{?");
    }

    public static String getErrorMessage(String errorMessage, String modelId, Boolean isHidden) {
        if (BooleanUtils.isTrue((Boolean)isHidden)) {
            return errorMessage;
        }
        return errorMessage + " Model ID: " + modelId;
    }

    public static List<String> collectToStringPrefixes(Map<String, String> map) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String key : map.keySet()) {
            String value = map.get(key);
            if (value == null) continue;
            Pattern pattern = Pattern.compile("\\$\\{parameters\\.(.+?)\\.toString\\(\\)\\}");
            Matcher matcher = pattern.matcher(value);
            while (matcher.find()) {
                String prefix = matcher.group(1);
                prefixes.add(prefix);
            }
        }
        return prefixes;
    }

    public static Map<String, String> parseParameters(Map<String, String> parameters) {
        List<String> toStringParametersPrefixes;
        if (parameters != null && !(toStringParametersPrefixes = StringUtils.collectToStringPrefixes(parameters)).isEmpty()) {
            for (String prefix : toStringParametersPrefixes) {
                String value = parameters.get(prefix);
                if (value == null) continue;
                parameters.put(prefix + TO_STRING_FUNCTION_NAME, StringUtils.processTextDoc(value));
            }
        }
        return parameters;
    }

    public static String obtainFieldNameFromJsonPath(String jsonPath) {
        String[] parts = jsonPath.split("\\.");
        return parts[parts.length - 1];
    }

    public static String getJsonPath(String jsonPathWithSource) {
        int startIndex = jsonPathWithSource.indexOf("$.");
        return startIndex != -1 ? jsonPathWithSource.substring(startIndex) : jsonPathWithSource;
    }

    public static boolean isValidJSONPath(String input) {
        if (input == null || input.isBlank()) {
            return false;
        }
        try {
            JsonPath.compile((String)input, (Predicate[])new Predicate[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

