/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine;

import java.util.Locale;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNMethodContext;

public final class SpaceTypeResolver {
    public static final SpaceTypeResolver INSTANCE = new SpaceTypeResolver();

    private SpaceTypeResolver() {
    }

    public SpaceType resolveSpaceType(KNNMethodContext knnMethodContext, VectorDataType vectorDataType, String topLevelSpaceTypeString) {
        SpaceType methodSpaceType = this.getSpaceTypeFromMethodContext(knnMethodContext);
        SpaceType topLevelSpaceType = this.getSpaceTypeFromString(topLevelSpaceTypeString);
        if (!this.isSpaceTypeConfigured(methodSpaceType) && !this.isSpaceTypeConfigured(topLevelSpaceType)) {
            return this.getSpaceTypeFromVectorDataType(vectorDataType);
        }
        if (!this.isSpaceTypeConfigured(methodSpaceType)) {
            return topLevelSpaceType;
        }
        if (!this.isSpaceTypeConfigured(topLevelSpaceType)) {
            return methodSpaceType;
        }
        if (methodSpaceType == topLevelSpaceType) {
            return topLevelSpaceType;
        }
        throw new MapperParsingException(String.format(Locale.ROOT, "Cannot specify conflicting space types: \"[%s]\" \"[%s]\"", methodSpaceType.getValue(), topLevelSpaceType.getValue()));
    }

    private SpaceType getSpaceTypeFromMethodContext(KNNMethodContext knnMethodContext) {
        if (knnMethodContext == null) {
            return SpaceType.UNDEFINED;
        }
        return knnMethodContext.getSpaceType();
    }

    private SpaceType getSpaceTypeFromVectorDataType(VectorDataType vectorDataType) {
        if (vectorDataType == VectorDataType.BINARY) {
            return SpaceType.DEFAULT_BINARY;
        }
        return SpaceType.DEFAULT;
    }

    private SpaceType getSpaceTypeFromString(String spaceType) {
        if (Strings.isEmpty((CharSequence)spaceType)) {
            return SpaceType.UNDEFINED;
        }
        return SpaceType.getSpace(spaceType);
    }

    private boolean isSpaceTypeConfigured(SpaceType spaceType) {
        return spaceType != null && spaceType != SpaceType.UNDEFINED;
    }
}

