/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN990Codec;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatFieldVectorsWriter;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.RamUsageEstimator;

class NativeEngineFieldVectorsWriter<T>
extends KnnFieldVectorsWriter<T> {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(NativeEngineFieldVectorsWriter.class);
    private final FieldInfo fieldInfo;
    private final Map<Integer, T> vectors;
    private int lastDocID = -1;
    private final DocsWithFieldSet docsWithField;
    private final InfoStream infoStream;
    private final FlatFieldVectorsWriter<T> flatFieldVectorsWriter;

    static NativeEngineFieldVectorsWriter<?> create(FieldInfo fieldInfo, FlatFieldVectorsWriter<?> flatFieldVectorsWriter, InfoStream infoStream) {
        switch (fieldInfo.getVectorEncoding()) {
            case FLOAT32: {
                return new NativeEngineFieldVectorsWriter(fieldInfo, flatFieldVectorsWriter, infoStream);
            }
            case BYTE: {
                return new NativeEngineFieldVectorsWriter(fieldInfo, flatFieldVectorsWriter, infoStream);
            }
        }
        throw new IllegalStateException("Unsupported Vector encoding : " + fieldInfo.getVectorEncoding());
    }

    private NativeEngineFieldVectorsWriter(FieldInfo fieldInfo, FlatFieldVectorsWriter<T> flatFieldVectorsWriter, InfoStream infoStream) {
        this.fieldInfo = fieldInfo;
        this.infoStream = infoStream;
        this.vectors = new HashMap<Integer, T>();
        this.docsWithField = new DocsWithFieldSet();
        this.flatFieldVectorsWriter = flatFieldVectorsWriter;
    }

    public void addValue(int docID, T vectorValue) throws IOException {
        if (docID == this.lastDocID) {
            throw new IllegalArgumentException("[NativeEngineKNNVectorWriter]VectorValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        assert (docID > this.lastDocID);
        this.flatFieldVectorsWriter.addValue(docID, vectorValue);
        this.vectors.put(docID, vectorValue);
        this.docsWithField.add(docID);
        this.lastDocID = docID;
    }

    public T copyValue(T vectorValue) {
        throw new UnsupportedOperationException("NativeEngineVectorFieldsWriter doesn't support copyValue operation");
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.docsWithField.ramBytesUsed() + (long)this.vectors.size() * (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + (long)this.vectors.size() * RamUsageEstimator.shallowSizeOfInstance(Integer.class) + (long)this.vectors.size() * (long)this.fieldInfo.getVectorDimension() * (long)this.fieldInfo.getVectorEncoding().byteSize + this.flatFieldVectorsWriter.ramBytesUsed();
    }

    @Generated
    public FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    @Generated
    public Map<Integer, T> getVectors() {
        return this.vectors;
    }

    @Generated
    public DocsWithFieldSet getDocsWithField() {
        return this.docsWithField;
    }
}

