/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsResponse;
import software.amazon.awssdk.services.ec2.model.IpamDiscoveredAccount;

public class GetIpamDiscoveredAccountsIterable
implements SdkIterable<GetIpamDiscoveredAccountsResponse> {
    private final Ec2Client client;
    private final GetIpamDiscoveredAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetIpamDiscoveredAccountsIterable(Ec2Client client, GetIpamDiscoveredAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetIpamDiscoveredAccountsResponseFetcher();
    }

    public Iterator<GetIpamDiscoveredAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamDiscoveredAccount> ipamDiscoveredAccounts() {
        Function<GetIpamDiscoveredAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamDiscoveredAccounts() != null) {
                return response.ipamDiscoveredAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetIpamDiscoveredAccountsResponseFetcher
    implements SyncPageFetcher<GetIpamDiscoveredAccountsResponse> {
        private GetIpamDiscoveredAccountsResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamDiscoveredAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetIpamDiscoveredAccountsResponse nextPage(GetIpamDiscoveredAccountsResponse previousPage) {
            if (previousPage == null) {
                return GetIpamDiscoveredAccountsIterable.this.client.getIpamDiscoveredAccounts(GetIpamDiscoveredAccountsIterable.this.firstRequest);
            }
            return GetIpamDiscoveredAccountsIterable.this.client.getIpamDiscoveredAccounts((GetIpamDiscoveredAccountsRequest)((Object)GetIpamDiscoveredAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

