/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse;
import software.amazon.awssdk.services.ec2.model.InstanceTypeInfoFromInstanceRequirements;

public class GetInstanceTypesFromInstanceRequirementsPublisher
implements SdkPublisher<GetInstanceTypesFromInstanceRequirementsResponse> {
    private final Ec2AsyncClient client;
    private final GetInstanceTypesFromInstanceRequirementsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetInstanceTypesFromInstanceRequirementsPublisher(Ec2AsyncClient client, GetInstanceTypesFromInstanceRequirementsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetInstanceTypesFromInstanceRequirementsPublisher(Ec2AsyncClient client, GetInstanceTypesFromInstanceRequirementsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetInstanceTypesFromInstanceRequirementsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetInstanceTypesFromInstanceRequirementsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceTypeInfoFromInstanceRequirements> instanceTypes() {
        Function<GetInstanceTypesFromInstanceRequirementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceTypes() != null) {
                return response.instanceTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetInstanceTypesFromInstanceRequirementsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetInstanceTypesFromInstanceRequirementsResponseFetcher
    implements AsyncPageFetcher<GetInstanceTypesFromInstanceRequirementsResponse> {
        private GetInstanceTypesFromInstanceRequirementsResponseFetcher() {
        }

        public boolean hasNextPage(GetInstanceTypesFromInstanceRequirementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetInstanceTypesFromInstanceRequirementsResponse> nextPage(GetInstanceTypesFromInstanceRequirementsResponse previousPage) {
            if (previousPage == null) {
                return GetInstanceTypesFromInstanceRequirementsPublisher.this.client.getInstanceTypesFromInstanceRequirements(GetInstanceTypesFromInstanceRequirementsPublisher.this.firstRequest);
            }
            return GetInstanceTypesFromInstanceRequirementsPublisher.this.client.getInstanceTypesFromInstanceRequirements((GetInstanceTypesFromInstanceRequirementsRequest)((Object)GetInstanceTypesFromInstanceRequirementsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

