/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion;

public class DescribeLaunchTemplateVersionsPublisher
implements SdkPublisher<DescribeLaunchTemplateVersionsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeLaunchTemplateVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLaunchTemplateVersionsPublisher(Ec2AsyncClient client, DescribeLaunchTemplateVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLaunchTemplateVersionsPublisher(Ec2AsyncClient client, DescribeLaunchTemplateVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLaunchTemplateVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLaunchTemplateVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LaunchTemplateVersion> launchTemplateVersions() {
        Function<DescribeLaunchTemplateVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.launchTemplateVersions() != null) {
                return response.launchTemplateVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeLaunchTemplateVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeLaunchTemplateVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeLaunchTemplateVersionsResponse> {
        private DescribeLaunchTemplateVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLaunchTemplateVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeLaunchTemplateVersionsResponse> nextPage(DescribeLaunchTemplateVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLaunchTemplateVersionsPublisher.this.client.describeLaunchTemplateVersions(DescribeLaunchTemplateVersionsPublisher.this.firstRequest);
            }
            return DescribeLaunchTemplateVersionsPublisher.this.client.describeLaunchTemplateVersions((DescribeLaunchTemplateVersionsRequest)((Object)DescribeLaunchTemplateVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

