/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublicIpv4PoolRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PublicIpv4PoolRange> {
    private static final SdkField<String> FIRST_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirstAddress").getter(PublicIpv4PoolRange.getter(PublicIpv4PoolRange::firstAddress)).setter(PublicIpv4PoolRange.setter(Builder::firstAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstAddress").unmarshallLocationName("firstAddress").build()}).build();
    private static final SdkField<String> LAST_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastAddress").getter(PublicIpv4PoolRange.getter(PublicIpv4PoolRange::lastAddress)).setter(PublicIpv4PoolRange.setter(Builder::lastAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAddress").unmarshallLocationName("lastAddress").build()}).build();
    private static final SdkField<Integer> ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AddressCount").getter(PublicIpv4PoolRange.getter(PublicIpv4PoolRange::addressCount)).setter(PublicIpv4PoolRange.setter(Builder::addressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressCount").unmarshallLocationName("addressCount").build()}).build();
    private static final SdkField<Integer> AVAILABLE_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableAddressCount").getter(PublicIpv4PoolRange.getter(PublicIpv4PoolRange::availableAddressCount)).setter(PublicIpv4PoolRange.setter(Builder::availableAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableAddressCount").unmarshallLocationName("availableAddressCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_ADDRESS_FIELD, LAST_ADDRESS_FIELD, ADDRESS_COUNT_FIELD, AVAILABLE_ADDRESS_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String firstAddress;
    private final String lastAddress;
    private final Integer addressCount;
    private final Integer availableAddressCount;

    private PublicIpv4PoolRange(BuilderImpl builder) {
        this.firstAddress = builder.firstAddress;
        this.lastAddress = builder.lastAddress;
        this.addressCount = builder.addressCount;
        this.availableAddressCount = builder.availableAddressCount;
    }

    public final String firstAddress() {
        return this.firstAddress;
    }

    public final String lastAddress() {
        return this.lastAddress;
    }

    public final Integer addressCount() {
        return this.addressCount;
    }

    public final Integer availableAddressCount() {
        return this.availableAddressCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.firstAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableAddressCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicIpv4PoolRange)) {
            return false;
        }
        PublicIpv4PoolRange other = (PublicIpv4PoolRange)obj;
        return Objects.equals(this.firstAddress(), other.firstAddress()) && Objects.equals(this.lastAddress(), other.lastAddress()) && Objects.equals(this.addressCount(), other.addressCount()) && Objects.equals(this.availableAddressCount(), other.availableAddressCount());
    }

    public final String toString() {
        return ToString.builder((String)"PublicIpv4PoolRange").add("FirstAddress", (Object)this.firstAddress()).add("LastAddress", (Object)this.lastAddress()).add("AddressCount", (Object)this.addressCount()).add("AvailableAddressCount", (Object)this.availableAddressCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirstAddress": {
                return Optional.ofNullable(clazz.cast(this.firstAddress()));
            }
            case "LastAddress": {
                return Optional.ofNullable(clazz.cast(this.lastAddress()));
            }
            case "AddressCount": {
                return Optional.ofNullable(clazz.cast(this.addressCount()));
            }
            case "AvailableAddressCount": {
                return Optional.ofNullable(clazz.cast(this.availableAddressCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicIpv4PoolRange, T> g) {
        return obj -> g.apply((PublicIpv4PoolRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String firstAddress;
        private String lastAddress;
        private Integer addressCount;
        private Integer availableAddressCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicIpv4PoolRange model) {
            this.firstAddress(model.firstAddress);
            this.lastAddress(model.lastAddress);
            this.addressCount(model.addressCount);
            this.availableAddressCount(model.availableAddressCount);
        }

        public final String getFirstAddress() {
            return this.firstAddress;
        }

        public final void setFirstAddress(String firstAddress) {
            this.firstAddress = firstAddress;
        }

        @Override
        public final Builder firstAddress(String firstAddress) {
            this.firstAddress = firstAddress;
            return this;
        }

        public final String getLastAddress() {
            return this.lastAddress;
        }

        public final void setLastAddress(String lastAddress) {
            this.lastAddress = lastAddress;
        }

        @Override
        public final Builder lastAddress(String lastAddress) {
            this.lastAddress = lastAddress;
            return this;
        }

        public final Integer getAddressCount() {
            return this.addressCount;
        }

        public final void setAddressCount(Integer addressCount) {
            this.addressCount = addressCount;
        }

        @Override
        public final Builder addressCount(Integer addressCount) {
            this.addressCount = addressCount;
            return this;
        }

        public final Integer getAvailableAddressCount() {
            return this.availableAddressCount;
        }

        public final void setAvailableAddressCount(Integer availableAddressCount) {
            this.availableAddressCount = availableAddressCount;
        }

        @Override
        public final Builder availableAddressCount(Integer availableAddressCount) {
            this.availableAddressCount = availableAddressCount;
            return this;
        }

        public PublicIpv4PoolRange build() {
            return new PublicIpv4PoolRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PublicIpv4PoolRange> {
        public Builder firstAddress(String var1);

        public Builder lastAddress(String var1);

        public Builder addressCount(Integer var1);

        public Builder availableAddressCount(Integer var1);
    }
}

