/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamPoolCidr;
import software.amazon.awssdk.services.ec2.model.IpamPoolCidrSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIpamPoolCidrsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetIpamPoolCidrsResponse> {
    private static final SdkField<List<IpamPoolCidr>> IPAM_POOL_CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamPoolCidrs").getter(GetIpamPoolCidrsResponse.getter(GetIpamPoolCidrsResponse::ipamPoolCidrs)).setter(GetIpamPoolCidrsResponse.setter(Builder::ipamPoolCidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolCidrSet").unmarshallLocationName("ipamPoolCidrSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamPoolCidr::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetIpamPoolCidrsResponse.getter(GetIpamPoolCidrsResponse::nextToken)).setter(GetIpamPoolCidrsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POOL_CIDRS_FIELD, NEXT_TOKEN_FIELD));
    private final List<IpamPoolCidr> ipamPoolCidrs;
    private final String nextToken;

    private GetIpamPoolCidrsResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPoolCidrs = builder.ipamPoolCidrs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIpamPoolCidrs() {
        return this.ipamPoolCidrs != null && !(this.ipamPoolCidrs instanceof SdkAutoConstructList);
    }

    public final List<IpamPoolCidr> ipamPoolCidrs() {
        return this.ipamPoolCidrs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamPoolCidrs() ? this.ipamPoolCidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamPoolCidrsResponse)) {
            return false;
        }
        GetIpamPoolCidrsResponse other = (GetIpamPoolCidrsResponse)((Object)obj);
        return this.hasIpamPoolCidrs() == other.hasIpamPoolCidrs() && Objects.equals(this.ipamPoolCidrs(), other.ipamPoolCidrs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetIpamPoolCidrsResponse").add("IpamPoolCidrs", this.hasIpamPoolCidrs() ? this.ipamPoolCidrs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamPoolCidrs": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolCidrs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIpamPoolCidrsResponse, T> g) {
        return obj -> g.apply((GetIpamPoolCidrsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<IpamPoolCidr> ipamPoolCidrs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamPoolCidrsResponse model) {
            super(model);
            this.ipamPoolCidrs(model.ipamPoolCidrs);
            this.nextToken(model.nextToken);
        }

        public final List<IpamPoolCidr.Builder> getIpamPoolCidrs() {
            List<IpamPoolCidr.Builder> result = IpamPoolCidrSetCopier.copyToBuilder(this.ipamPoolCidrs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamPoolCidrs(Collection<IpamPoolCidr.BuilderImpl> ipamPoolCidrs) {
            this.ipamPoolCidrs = IpamPoolCidrSetCopier.copyFromBuilder(ipamPoolCidrs);
        }

        @Override
        public final Builder ipamPoolCidrs(Collection<IpamPoolCidr> ipamPoolCidrs) {
            this.ipamPoolCidrs = IpamPoolCidrSetCopier.copy(ipamPoolCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPoolCidrs(IpamPoolCidr ... ipamPoolCidrs) {
            this.ipamPoolCidrs(Arrays.asList(ipamPoolCidrs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPoolCidrs(Consumer<IpamPoolCidr.Builder> ... ipamPoolCidrs) {
            this.ipamPoolCidrs(Stream.of(ipamPoolCidrs).map(c -> (IpamPoolCidr)((IpamPoolCidr.Builder)IpamPoolCidr.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetIpamPoolCidrsResponse build() {
            return new GetIpamPoolCidrsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIpamPoolCidrsResponse> {
        public Builder ipamPoolCidrs(Collection<IpamPoolCidr> var1);

        public Builder ipamPoolCidrs(IpamPoolCidr ... var1);

        public Builder ipamPoolCidrs(Consumer<IpamPoolCidr.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

