"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _constants = require("../../utils/constants");
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    transformService
  } = services;
  router.get({
    path: _constants.NODE_API.TRANSFORMS,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, transformService.getTransforms);
  router.get({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, transformService.getTransform);
  router.post({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}/_stop`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, transformService.stopTransform);
  router.post({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}/_start`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, transformService.startTransform);
  router.delete({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, transformService.deleteTransform);
  router.put({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number()),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, transformService.putTransform);
  router.post({
    path: `${_constants.NODE_API._SEARCH_SAMPLE_DATA}/{index}`,
    validate: {
      params: _configSchema.schema.object({
        index: _configSchema.schema.string({
          validate: value => {
            const invalidCharactersPattern = /[\s,:\"*+\/\\|?#><]/;
            if (value !== value.toLowerCase() || value.startsWith("_") || value.startsWith("-") || invalidCharactersPattern.test(value)) {
              return "Invalid index name.";
            }
            return undefined;
          }
        })
      }),
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string({
            maxLength: 100000
          })
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, transformService.searchSampleData);
  router.post({
    path: `${_constants.NODE_API.TRANSFORMS}/_preview`,
    validate: {
      body: _configSchema.schema.object({
        transform: _configSchema.schema.object({
          source_index: _configSchema.schema.string({
            validate: value => {
              const invalidCharactersPattern = /[\s,:\"*+\/\\|?#><]/;
              if (value !== value.toLowerCase() || value.startsWith("_") || value.startsWith("-") || invalidCharactersPattern.test(value)) {
                return "Invalid index name.";
              }
              return undefined;
            }
          }),
          target_index: _configSchema.schema.string({
            validate: value => {
              const invalidCharactersPattern = /[\s,:\"*+\/\\|?#><]/;
              if (value !== value.toLowerCase() || value.startsWith("_") || value.startsWith("-") || invalidCharactersPattern.test(value)) {
                return "Invalid index name.";
              }
              return undefined;
            }
          })
        }, {
          unknowns: "allow"
        })
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string({
            maxLength: 100000
          })
        } : {})
      })
    }
  }, transformService.previewTransform);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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